/* global document */
import { Texture2D } from 'luma.gl';

var MAX_CANVAS_WIDTH = 1024;
var fontSize = 64;
var padding = 2;

var charList = [];
for (var i = 32; i < 128; i++) {
  charList.push(String.fromCharCode(i));
}

function setTextStyle(ctx, fontFamily) {
  ctx.font = fontSize + 'px ' + fontFamily;
  ctx.fillStyle = '#000';
  ctx.textBaseline = 'hanging';
  ctx.textAlign = 'left';
}

export function makeFontAtlas(gl, fontFamily) {
  var canvas = document.createElement('canvas');
  var ctx = canvas.getContext('2d');
  setTextStyle(ctx, fontFamily);

  // measure texts
  var row = 0;
  var x = 0;
  var mapping = {};

  charList.forEach(function (char) {
    var _ctx$measureText = ctx.measureText(char),
        width = _ctx$measureText.width;

    if (x + width > MAX_CANVAS_WIDTH) {
      x = 0;
      row++;
    }
    mapping[char] = {
      x: x,
      y: row * (fontSize + padding),
      width: width,
      height: fontSize,
      mask: true
    };
    x += width;
  });

  canvas.width = MAX_CANVAS_WIDTH;
  canvas.height = (row + 1) * (fontSize + padding);

  setTextStyle(ctx, fontFamily);
  for (var char in mapping) {
    ctx.fillText(char, mapping[char].x, mapping[char].y);
  }

  return {
    mapping: mapping,
    texture: new Texture2D(gl, {
      pixels: canvas
      // no need to specify texture filter here
      // icon layer use the most accurate mode by default
    })
  };
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL3NyYy9leHBlcmltZW50YWwtbGF5ZXJzL3NyYy90ZXh0LWxheWVyL2ZvbnQtYXRsYXMuanMiXSwibmFtZXMiOlsiVGV4dHVyZTJEIiwiTUFYX0NBTlZBU19XSURUSCIsImZvbnRTaXplIiwicGFkZGluZyIsImNoYXJMaXN0IiwiaSIsInB1c2giLCJTdHJpbmciLCJmcm9tQ2hhckNvZGUiLCJzZXRUZXh0U3R5bGUiLCJjdHgiLCJmb250RmFtaWx5IiwiZm9udCIsImZpbGxTdHlsZSIsInRleHRCYXNlbGluZSIsInRleHRBbGlnbiIsIm1ha2VGb250QXRsYXMiLCJnbCIsImNhbnZhcyIsImRvY3VtZW50IiwiY3JlYXRlRWxlbWVudCIsImdldENvbnRleHQiLCJyb3ciLCJ4IiwibWFwcGluZyIsImZvckVhY2giLCJtZWFzdXJlVGV4dCIsImNoYXIiLCJ3aWR0aCIsInkiLCJoZWlnaHQiLCJtYXNrIiwiZmlsbFRleHQiLCJ0ZXh0dXJlIiwicGl4ZWxzIl0sIm1hcHBpbmdzIjoiQUFBQTtBQUNBLFNBQVFBLFNBQVIsUUFBd0IsU0FBeEI7O0FBRUEsSUFBTUMsbUJBQW1CLElBQXpCO0FBQ0EsSUFBTUMsV0FBVyxFQUFqQjtBQUNBLElBQU1DLFVBQVUsQ0FBaEI7O0FBRUEsSUFBTUMsV0FBVyxFQUFqQjtBQUNBLEtBQUssSUFBSUMsSUFBSSxFQUFiLEVBQWlCQSxJQUFJLEdBQXJCLEVBQTBCQSxHQUExQixFQUErQjtBQUM3QkQsV0FBU0UsSUFBVCxDQUFjQyxPQUFPQyxZQUFQLENBQW9CSCxDQUFwQixDQUFkO0FBQ0Q7O0FBRUQsU0FBU0ksWUFBVCxDQUFzQkMsR0FBdEIsRUFBMkJDLFVBQTNCLEVBQXVDO0FBQ3JDRCxNQUFJRSxJQUFKLEdBQWNWLFFBQWQsV0FBNEJTLFVBQTVCO0FBQ0FELE1BQUlHLFNBQUosR0FBZ0IsTUFBaEI7QUFDQUgsTUFBSUksWUFBSixHQUFtQixTQUFuQjtBQUNBSixNQUFJSyxTQUFKLEdBQWdCLE1BQWhCO0FBQ0Q7O0FBRUQsT0FBTyxTQUFTQyxhQUFULENBQXVCQyxFQUF2QixFQUEyQk4sVUFBM0IsRUFBdUM7QUFDNUMsTUFBTU8sU0FBU0MsU0FBU0MsYUFBVCxDQUF1QixRQUF2QixDQUFmO0FBQ0EsTUFBTVYsTUFBTVEsT0FBT0csVUFBUCxDQUFrQixJQUFsQixDQUFaO0FBQ0FaLGVBQWFDLEdBQWIsRUFBa0JDLFVBQWxCOztBQUVBO0FBQ0EsTUFBSVcsTUFBTSxDQUFWO0FBQ0EsTUFBSUMsSUFBSSxDQUFSO0FBQ0EsTUFBTUMsVUFBVSxFQUFoQjs7QUFFQXBCLFdBQVNxQixPQUFULENBQWlCLGdCQUFRO0FBQUEsMkJBQ1BmLElBQUlnQixXQUFKLENBQWdCQyxJQUFoQixDQURPO0FBQUEsUUFDaEJDLEtBRGdCLG9CQUNoQkEsS0FEZ0I7O0FBRXZCLFFBQUlMLElBQUlLLEtBQUosR0FBWTNCLGdCQUFoQixFQUFrQztBQUNoQ3NCLFVBQUksQ0FBSjtBQUNBRDtBQUNEO0FBQ0RFLFlBQVFHLElBQVIsSUFBZ0I7QUFDZEosVUFEYztBQUVkTSxTQUFHUCxPQUFPcEIsV0FBV0MsT0FBbEIsQ0FGVztBQUdkeUIsa0JBSGM7QUFJZEUsY0FBUTVCLFFBSk07QUFLZDZCLFlBQU07QUFMUSxLQUFoQjtBQU9BUixTQUFLSyxLQUFMO0FBQ0QsR0FkRDs7QUFnQkFWLFNBQU9VLEtBQVAsR0FBZTNCLGdCQUFmO0FBQ0FpQixTQUFPWSxNQUFQLEdBQWdCLENBQUNSLE1BQU0sQ0FBUCxLQUFhcEIsV0FBV0MsT0FBeEIsQ0FBaEI7O0FBRUFNLGVBQWFDLEdBQWIsRUFBa0JDLFVBQWxCO0FBQ0EsT0FBSyxJQUFNZ0IsSUFBWCxJQUFtQkgsT0FBbkIsRUFBNEI7QUFDMUJkLFFBQUlzQixRQUFKLENBQWFMLElBQWIsRUFBbUJILFFBQVFHLElBQVIsRUFBY0osQ0FBakMsRUFBb0NDLFFBQVFHLElBQVIsRUFBY0UsQ0FBbEQ7QUFDRDs7QUFFRCxTQUFPO0FBQ0xMLG9CQURLO0FBRUxTLGFBQVMsSUFBSWpDLFNBQUosQ0FBY2lCLEVBQWQsRUFBa0I7QUFDekJpQixjQUFRaEI7QUFDUjtBQUNBO0FBSHlCLEtBQWxCO0FBRkosR0FBUDtBQVFEIiwiZmlsZSI6ImZvbnQtYXRsYXMuanMiLCJzb3VyY2VzQ29udGVudCI6WyIvKiBnbG9iYWwgZG9jdW1lbnQgKi9cbmltcG9ydCB7VGV4dHVyZTJEfSBmcm9tICdsdW1hLmdsJztcblxuY29uc3QgTUFYX0NBTlZBU19XSURUSCA9IDEwMjQ7XG5jb25zdCBmb250U2l6ZSA9IDY0O1xuY29uc3QgcGFkZGluZyA9IDI7XG5cbmNvbnN0IGNoYXJMaXN0ID0gW107XG5mb3IgKGxldCBpID0gMzI7IGkgPCAxMjg7IGkrKykge1xuICBjaGFyTGlzdC5wdXNoKFN0cmluZy5mcm9tQ2hhckNvZGUoaSkpO1xufVxuXG5mdW5jdGlvbiBzZXRUZXh0U3R5bGUoY3R4LCBmb250RmFtaWx5KSB7XG4gIGN0eC5mb250ID0gYCR7Zm9udFNpemV9cHggJHtmb250RmFtaWx5fWA7XG4gIGN0eC5maWxsU3R5bGUgPSAnIzAwMCc7XG4gIGN0eC50ZXh0QmFzZWxpbmUgPSAnaGFuZ2luZyc7XG4gIGN0eC50ZXh0QWxpZ24gPSAnbGVmdCc7XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBtYWtlRm9udEF0bGFzKGdsLCBmb250RmFtaWx5KSB7XG4gIGNvbnN0IGNhbnZhcyA9IGRvY3VtZW50LmNyZWF0ZUVsZW1lbnQoJ2NhbnZhcycpO1xuICBjb25zdCBjdHggPSBjYW52YXMuZ2V0Q29udGV4dCgnMmQnKTtcbiAgc2V0VGV4dFN0eWxlKGN0eCwgZm9udEZhbWlseSk7XG5cbiAgLy8gbWVhc3VyZSB0ZXh0c1xuICBsZXQgcm93ID0gMDtcbiAgbGV0IHggPSAwO1xuICBjb25zdCBtYXBwaW5nID0ge307XG5cbiAgY2hhckxpc3QuZm9yRWFjaChjaGFyID0+IHtcbiAgICBjb25zdCB7d2lkdGh9ID0gY3R4Lm1lYXN1cmVUZXh0KGNoYXIpO1xuICAgIGlmICh4ICsgd2lkdGggPiBNQVhfQ0FOVkFTX1dJRFRIKSB7XG4gICAgICB4ID0gMDtcbiAgICAgIHJvdysrO1xuICAgIH1cbiAgICBtYXBwaW5nW2NoYXJdID0ge1xuICAgICAgeCxcbiAgICAgIHk6IHJvdyAqIChmb250U2l6ZSArIHBhZGRpbmcpLFxuICAgICAgd2lkdGgsXG4gICAgICBoZWlnaHQ6IGZvbnRTaXplLFxuICAgICAgbWFzazogdHJ1ZVxuICAgIH07XG4gICAgeCArPSB3aWR0aDtcbiAgfSk7XG5cbiAgY2FudmFzLndpZHRoID0gTUFYX0NBTlZBU19XSURUSDtcbiAgY2FudmFzLmhlaWdodCA9IChyb3cgKyAxKSAqIChmb250U2l6ZSArIHBhZGRpbmcpO1xuXG4gIHNldFRleHRTdHlsZShjdHgsIGZvbnRGYW1pbHkpO1xuICBmb3IgKGNvbnN0IGNoYXIgaW4gbWFwcGluZykge1xuICAgIGN0eC5maWxsVGV4dChjaGFyLCBtYXBwaW5nW2NoYXJdLngsIG1hcHBpbmdbY2hhcl0ueSk7XG4gIH1cblxuICByZXR1cm4ge1xuICAgIG1hcHBpbmcsXG4gICAgdGV4dHVyZTogbmV3IFRleHR1cmUyRChnbCwge1xuICAgICAgcGl4ZWxzOiBjYW52YXNcbiAgICAgIC8vIG5vIG5lZWQgdG8gc3BlY2lmeSB0ZXh0dXJlIGZpbHRlciBoZXJlXG4gICAgICAvLyBpY29uIGxheWVyIHVzZSB0aGUgbW9zdCBhY2N1cmF0ZSBtb2RlIGJ5IGRlZmF1bHRcbiAgICB9KVxuICB9O1xufVxuIl19