// Copyright (c) 2015 - 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
/* eslint-disable max-len */

var experimental = {};

//
// CORE LIBRARY
//

export {
// LIB
COORDINATE_SYSTEM, LayerManager, AttributeManager, Layer, CompositeLayer,
// Viewports
Viewport, WebMercatorViewport, PerspectiveViewport, OrthographicViewport,
// Shader modules
project, project64, lighting } from './core';

// EXPERIMENTAL CORE LIB CLASSES (May change in minor version bumps, use at your own risk)
import { experimental as CoreExperimental } from './core';

var ViewState = CoreExperimental.ViewState,
    FirstPersonState = CoreExperimental.FirstPersonState,
    OrbitState = CoreExperimental.OrbitState,
    MapState = CoreExperimental.MapState,
    Controller = CoreExperimental.Controller,
    FirstPersonController = CoreExperimental.FirstPersonController,
    FirstPersonViewport = CoreExperimental.FirstPersonViewport,
    OrbitViewport = CoreExperimental.OrbitViewport,
    ThirdPersonViewport = CoreExperimental.ThirdPersonViewport,
    TRANSITION_EVENTS = CoreExperimental.TRANSITION_EVENTS,
    LinearInterpolator = CoreExperimental.LinearInterpolator,
    ViewportFlyToInterpolator = CoreExperimental.ViewportFlyToInterpolator,
    DeckGLJS = CoreExperimental.DeckGLJS,
    MapControllerJS = CoreExperimental.MapControllerJS,
    EffectManager = CoreExperimental.EffectManager,
    Effect = CoreExperimental.Effect;


Object.assign(experimental, {
  // Unfinished controller/viewport classes
  ViewState: ViewState,
  FirstPersonState: FirstPersonState,
  OrbitState: OrbitState,
  MapState: MapState,

  Controller: Controller,
  FirstPersonController: FirstPersonController,

  FirstPersonViewport: FirstPersonViewport,
  OrbitViewport: OrbitViewport,
  ThirdPersonViewport: ThirdPersonViewport,

  // Transition bindings
  TRANSITION_EVENTS: TRANSITION_EVENTS,
  LinearInterpolator: LinearInterpolator,
  ViewportFlyToInterpolator: ViewportFlyToInterpolator,

  // Pure JS (non-React) API
  DeckGLJS: DeckGLJS,
  MapControllerJS: MapControllerJS,

  // Effects base classes
  EffectManager: EffectManager,
  Effect: Effect
});

// Experimental Data Accessor Helpers
// INTERNAL - TODO remove from experimental exports
var TransitionManager = CoreExperimental.TransitionManager,
    extractViewportFrom = CoreExperimental.extractViewportFrom,
    BinSorter = CoreExperimental.BinSorter,
    linearScale = CoreExperimental.linearScale,
    getLinearScale = CoreExperimental.getLinearScale,
    quantizeScale = CoreExperimental.quantizeScale,
    getQuantizeScale = CoreExperimental.getQuantizeScale,
    clamp = CoreExperimental.clamp,
    defaultColorRange = CoreExperimental.defaultColorRange,
    log = CoreExperimental.log,
    get = CoreExperimental.get,
    count = CoreExperimental.count,
    flatten = CoreExperimental.flatten,
    countVertices = CoreExperimental.countVertices,
    flattenVertices = CoreExperimental.flattenVertices,
    fillArray = CoreExperimental.fillArray,
    enable64bitSupport = CoreExperimental.enable64bitSupport,
    fp64ify = CoreExperimental.fp64ify,
    fp64LowPart = CoreExperimental.fp64LowPart;


Object.assign(experimental, {
  // For react module
  TransitionManager: TransitionManager,
  extractViewportFrom: extractViewportFrom,

  // For layers
  BinSorter: BinSorter,
  linearScale: linearScale,
  getLinearScale: getLinearScale,
  quantizeScale: quantizeScale,
  getQuantizeScale: getQuantizeScale,
  clamp: clamp,
  defaultColorRange: defaultColorRange,

  log: log,

  get: get,
  count: count,

  flatten: flatten,
  countVertices: countVertices,
  flattenVertices: flattenVertices,
  fillArray: fillArray,

  enable64bitSupport: enable64bitSupport,
  fp64ify: fp64ify,
  fp64LowPart: fp64LowPart
});

//
// CORE LAYERS PACKAGE
//

export { ArcLayer, IconLayer, LineLayer, PointCloudLayer, ScatterplotLayer, ScreenGridLayer, GridLayer, GridCellLayer, HexagonLayer, HexagonCellLayer, PathLayer, PolygonLayer, GeoJsonLayer } from './core-layers';

//
// EFFECTS PACKAGE
//

import { default as ReflectionEffect } from './effects/experimental/reflection-effect/reflection-effect';

Object.assign(experimental, {
  ReflectionEffect: ReflectionEffect
});

//
// REACT BINDINGS PACKAGE
//

export { default, DeckGL } from './react';

// TODO - do we need to expose these?
import { MapController, OrbitController, ViewportController // TODO - merge with deck.gl?
} from './react';

Object.assign(experimental, {
  MapController: MapController,
  OrbitController: OrbitController,
  ViewportController: ViewportController
});

//
// EXPERIMENTAL EXPORTS
//

export { experimental };
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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