var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

// Copyright (c) 2015 - 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

import React, { createElement, cloneElement } from 'react';
import autobind from './utils/autobind';
import { inheritsFrom } from '../core/utils/inherits-from';
import { Layer, experimental } from '../core';
var DeckGLJS = experimental.DeckGLJS,
    log = experimental.log;

var DeckGL = function (_React$Component) {
  _inherits(DeckGL, _React$Component);

  function DeckGL(props) {
    _classCallCheck(this, DeckGL);

    var _this = _possibleConstructorReturn(this, (DeckGL.__proto__ || Object.getPrototypeOf(DeckGL)).call(this, props));

    _this.state = {};
    _this.children = [];
    autobind(_this);
    return _this;
  }

  _createClass(DeckGL, [{
    key: 'componentDidMount',
    value: function componentDidMount() {
      this.deck = new DeckGLJS(Object.assign({}, this.props, { canvas: this.overlay }));
      this._updateFromProps(this.props);
    }
  }, {
    key: 'componentWillReceiveProps',
    value: function componentWillReceiveProps(nextProps) {
      this._updateFromProps(nextProps);
    }
  }, {
    key: 'componentWillUnmount',
    value: function componentWillUnmount() {
      this.deck.finalize();
    }

    // Public API

  }, {
    key: 'queryObject',
    value: function queryObject(opts) {
      log.deprecated('queryObject', 'pickObject');
      return this.deck.pickObject(opts);
    }
  }, {
    key: 'pickObject',
    value: function pickObject(_ref) {
      var x = _ref.x,
          y = _ref.y,
          _ref$radius = _ref.radius,
          radius = _ref$radius === undefined ? 0 : _ref$radius,
          _ref$layerIds = _ref.layerIds,
          layerIds = _ref$layerIds === undefined ? null : _ref$layerIds;

      return this.deck.pickObject({ x: x, y: y, radius: radius, layerIds: layerIds });
    }
  }, {
    key: 'queryVisibleObjects',
    value: function queryVisibleObjects(opts) {
      log.deprecated('queryVisibleObjects', 'pickObjects');
      return this.pickObjects(opts);
    }
  }, {
    key: 'pickObjects',
    value: function pickObjects(_ref2) {
      var x = _ref2.x,
          y = _ref2.y,
          _ref2$width = _ref2.width,
          width = _ref2$width === undefined ? 1 : _ref2$width,
          _ref2$height = _ref2.height,
          height = _ref2$height === undefined ? 1 : _ref2$height,
          _ref2$layerIds = _ref2.layerIds,
          layerIds = _ref2$layerIds === undefined ? null : _ref2$layerIds;

      return this.deck.pickObjects({ x: x, y: y, width: width, height: height, layerIds: layerIds });
    }

    // Private Helpers

    // Extract any JSX layers from the react children
    // Needs to be called both from initial mount, and when new props arrive

  }, {
    key: '_updateFromProps',
    value: function _updateFromProps(nextProps) {
      // extract any deck.gl layers masquerading as react elements from props.children
      var _extractJSXLayers2 = this._extractJSXLayers(nextProps.children),
          layers = _extractJSXLayers2.layers,
          children = _extractJSXLayers2.children;

      if (this.deck) {
        this.deck.setProps(Object.assign({}, nextProps, {
          // Avoid modifying layers array if no JSX layers were found
          layers: layers ? [].concat(_toConsumableArray(layers), _toConsumableArray(nextProps.layers)) : nextProps.layers
        }));
      }

      this.children = children;
    }

    // extracts any deck.gl layers masquerading as react elements from props.children

  }, {
    key: '_extractJSXLayers',
    value: function _extractJSXLayers(children) {
      var reactChildren = []; // extract real react elements (i.e. not deck.gl layers)
      var layers = null; // extracted layer from react children, will add to deck.gl layer array

      React.Children.forEach(children, function (reactElement) {
        if (reactElement) {
          // For some reason Children.forEach doesn't filter out `null`s
          var LayerType = reactElement.type;
          if (inheritsFrom(LayerType, Layer)) {
            var layer = new LayerType(reactElement.props);
            layers = layers || [];
            layers.push(layer);
          } else {
            reactChildren.push(reactElement);
          }
        }
      });

      return { layers: layers, children: reactChildren };
    }

    // Iterate over viewport descriptors and render children associate with viewports
    // at the specified positions
    // TODO - Can we supply a similar function for the non-React case?

  }, {
    key: '_renderChildrenUnderViewports',
    value: function _renderChildrenUnderViewports(children) {
      var _this2 = this;

      // Flatten out nested viewports array
      var viewports = this.deck ? this.deck.getViewports() : [];

      // Build a viewport id to viewport index
      var viewportMap = {};
      viewports.forEach(function (viewport) {
        if (viewport.id) {
          viewportMap[viewport.id] = viewport;
        }
      });

      return children.map(
      // If child specifies props.viewportId, position under viewport, otherwise render as normal
      function (child, i) {
        return child.props.viewportId ? _this2._positionChild({ child: child, viewportMap: viewportMap, i: i }) : child;
      });
    }
  }, {
    key: '_positionChild',
    value: function _positionChild(_ref3) {
      var child = _ref3.child,
          viewportMap = _ref3.viewportMap,
          i = _ref3.i;
      var viewportId = child.props.viewportId;

      var viewport = viewportId && viewportMap[viewportId];

      // Drop (aut-hide) elements with viewportId that are not matched by any current viewport
      if (!viewport) {
        return null;
      }

      // Resolve potentially relative dimensions using the deck.gl container size
      var x = viewport.x,
          y = viewport.y,
          width = viewport.width,
          height = viewport.height;

      // Clone the element with width and height set per viewport

      var newProps = Object.assign({}, child.props, { width: width, height: height });

      // Inject map properties
      // TODO - this is too react-map-gl specific
      Object.assign(newProps, viewport.getMercatorParams(), {
        visible: viewport.isMapSynched()
      });

      var clone = cloneElement(child, newProps);

      // Wrap it in an absolutely positioning div
      var style = { position: 'absolute', left: x, top: y, width: width, height: height };
      var key = 'viewport-child-' + viewportId + '-' + i;
      return createElement('div', { key: key, id: key, style: style }, clone);
    }
  }, {
    key: 'render',
    value: function render() {
      var _this3 = this;

      // Render the background elements (typically react-map-gl instances)
      // using the viewport descriptors
      var children = this._renderChildrenUnderViewports(this.children);

      // Render deck.gl as last child
      var _props = this.props,
          id = _props.id,
          width = _props.width,
          height = _props.height,
          style = _props.style;

      var deck = createElement('canvas', {
        ref: function ref(c) {
          return _this3.overlay = c;
        },
        key: 'overlay',
        id: id,
        style: Object.assign({}, { position: 'absolute', left: 0, top: 0, width: width, height: height }, style)
      });
      children.push(deck);

      return createElement('div', { id: 'deckgl-wrapper' }, children);
    }
  }]);

  return DeckGL;
}(React.Component);

export default DeckGL;


DeckGL.propTypes = DeckGLJS.propTypes;
DeckGL.defaultProps = DeckGLJS.defaultProps;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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