var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

import { PureComponent, createElement } from 'react';
import OrbitControllerJS from '../../core/pure-js/orbit-controller-js';
import OrbitViewport from '../../core/viewports/orbit-viewport';

var OrbitController = function (_PureComponent) {
  _inherits(OrbitController, _PureComponent);

  _createClass(OrbitController, null, [{
    key: 'getViewport',

    // Returns a deck.gl Viewport instance, to be used with the DeckGL component
    value: function getViewport(viewport) {
      return new OrbitViewport(viewport);
    }
  }]);

  function OrbitController(props) {
    _classCallCheck(this, OrbitController);

    var _this = _possibleConstructorReturn(this, (OrbitController.__proto__ || Object.getPrototypeOf(OrbitController)).call(this, props));

    _this.controller = null;
    return _this;
  }

  _createClass(OrbitController, [{
    key: 'componentDidMount',
    value: function componentDidMount() {
      this.controller = new OrbitControllerJS(Object.assign({}, this.props, { canvas: this.eventCanvas }));
    }
  }, {
    key: 'componentWillUpdate',
    value: function componentWillUpdate(nextProps) {
      this.controller.setProps(nextProps);
    }
  }, {
    key: 'componentWillUnmount',
    value: function componentWillUnmount() {
      this.controller.finalize();
    }
  }, {
    key: 'render',
    value: function render() {
      var _this2 = this;

      var _props = this.props,
          width = _props.width,
          height = _props.height;


      var eventCanvasStyle = {
        width: width,
        height: height,
        position: 'relative'
      };

      return createElement('div', {
        key: 'map-controls',
        ref: function ref(c) {
          return _this2.eventCanvas = c;
        },
        style: eventCanvasStyle
      }, this.props.children);
    }
  }]);

  return OrbitController;
}(PureComponent);

export default OrbitController;


OrbitController.displayName = 'OrbitController';
OrbitController.propTypes = OrbitControllerJS.propTypes;
OrbitController.defaultProps = OrbitControllerJS.defaultProps;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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