var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

import { Component, createElement } from 'react';
import PropTypes from 'prop-types';

import { EventManager } from 'mjolnir.js';
import { experimental } from '../core';
var ViewportControls = experimental.ViewportControls,
    TransitionManager = experimental.TransitionManager;


import CURSOR from './utils/cursors';

var propTypes = {
  viewportState: PropTypes.func,
  state: PropTypes.object,

  /** Viewport props */
  /** The width of the map. */
  width: PropTypes.number.isRequired,
  /** The height of the map. */
  height: PropTypes.number.isRequired,
  /** The longitude of the center of the map. */
  longitude: PropTypes.number.isRequired,
  /** The latitude of the center of the map. */
  latitude: PropTypes.number.isRequired,
  /** The tile zoom level of the map. */
  zoom: PropTypes.number.isRequired,
  /** Specify the bearing of the viewport */
  bearing: PropTypes.number,
  /** Specify the pitch of the viewport */
  pitch: PropTypes.number,
  /** Altitude of the viewport camera. Default 1.5 "screen heights" */
  // Note: Non-public API, see https://github.com/mapbox/mapbox-gl-js/issues/1137
  altitude: PropTypes.number,
  // Camera position for FirstPersonViewport
  position: PropTypes.array,

  /** Viewport constraints */
  // Max zoom level
  maxZoom: PropTypes.number,
  // Min zoom level
  minZoom: PropTypes.number,
  // Max pitch in degrees
  maxPitch: PropTypes.number,
  // Min pitch in degrees
  minPitch: PropTypes.number,

  /**
   * `onViewportChange` callback is fired when the user interacted with the
   * map. The object passed to the callback contains viewport properties
   * such as `longitude`, `latitude`, `zoom` etc.
   */
  onViewportChange: PropTypes.func,

  /** Viewport transition **/
  // transition duration for viewport change
  transitionDuration: PropTypes.number,
  // an instance of ViewportTransitionInterpolator, can be used to perform custom transitions.
  transitionInterpolator: PropTypes.object,
  // type of interruption of current transition on update.
  transitionInterruption: PropTypes.number,
  // easing function
  transitionEasing: PropTypes.func,
  // transition status update functions
  onTransitionStart: PropTypes.func,
  onTransitionInterrupt: PropTypes.func,
  onTransitionEnd: PropTypes.func,

  /** Enables control event handling */
  // Scroll to zoom
  scrollZoom: PropTypes.bool,
  // Drag to pan
  dragPan: PropTypes.bool,
  // Drag to rotate
  dragRotate: PropTypes.bool,
  // Double click to zoom
  doubleClickZoom: PropTypes.bool,
  // Pinch to zoom / rotate
  touchZoomRotate: PropTypes.bool,

  /** Accessor that returns a cursor style to show interactive state */
  getCursor: PropTypes.func,

  // A map control instance to replace the default map controls
  // The object must expose one property: `events` as an array of subscribed
  // event names; and two methods: `setState(state)` and `handle(event)`
  controls: PropTypes.shape({
    events: PropTypes.arrayOf(PropTypes.string),
    handleEvent: PropTypes.func
  })
};

var getDefaultCursor = function getDefaultCursor(_ref) {
  var isDragging = _ref.isDragging;
  return isDragging ? CURSOR.GRABBING : CURSOR.GRAB;
};

var defaultProps = Object.assign({}, TransitionManager.defaultProps, {
  onViewportChange: null,

  scrollZoom: true,
  dragPan: true,
  dragRotate: true,
  doubleClickZoom: true,
  touchZoomRotate: true,

  getCursor: getDefaultCursor
});

var ViewportController = function (_Component) {
  _inherits(ViewportController, _Component);

  function ViewportController(props) {
    _classCallCheck(this, ViewportController);

    var _this = _possibleConstructorReturn(this, (ViewportController.__proto__ || Object.getPrototypeOf(ViewportController)).call(this, props));

    _this.state = {
      isDragging: false // Whether the cursor is down
    };
    return _this;
  }

  _createClass(ViewportController, [{
    key: 'componentDidMount',
    value: function componentDidMount() {
      this._eventManager = new EventManager(this.eventCanvas);

      // If props.controls is not provided, fallback to default MapControls instance
      // Cannot use defaultProps here because it needs to be per map instance
      this._controls = this.props.controls || new ViewportControls(this.props.viewportState);

      this._controls.setOptions(Object.assign({}, this.props, {
        onStateChange: this._onInteractiveStateChange.bind(this),
        eventManager: this._eventManager
      }));

      this._transitionManger = new TransitionManager(this.props);
    }
  }, {
    key: 'shouldComponentUpdate',
    value: function shouldComponentUpdate(nextProps, nextState) {
      if (this._transitionManger) {
        var transitionTriggered = this._transitionManger.processViewportChange(nextProps);
        // Skip this render to avoid jump during viewport transitions.
        return !transitionTriggered;
      }
      return true;
    }
  }, {
    key: 'componentWillUpdate',
    value: function componentWillUpdate(nextProps) {
      if (this._controls) {
        this._controls.setOptions(nextProps);
      }
    }
  }, {
    key: 'componentWillUnmount',
    value: function componentWillUnmount() {
      this._eventManager.destroy();
    }
  }, {
    key: '_onInteractiveStateChange',
    value: function _onInteractiveStateChange(_ref2) {
      var _ref2$isDragging = _ref2.isDragging,
          isDragging = _ref2$isDragging === undefined ? false : _ref2$isDragging;

      if (isDragging !== this.state.isDragging) {
        this.setState({ isDragging: isDragging });
      }
    }
  }, {
    key: 'render',
    value: function render() {
      var _this2 = this;

      var _props = this.props,
          width = _props.width,
          height = _props.height,
          getCursor = _props.getCursor;


      var eventCanvasStyle = {
        width: width,
        height: height,
        position: 'relative',
        cursor: getCursor(this.state)
      };

      return createElement('div', {
        key: 'map-controls',
        ref: function ref(c) {
          return _this2.eventCanvas = c;
        },
        style: eventCanvasStyle
      }, this.props.children);
    }
  }]);

  return ViewportController;
}(Component);

export default ViewportController;


ViewportController.displayName = 'ViewportController';
ViewportController.propTypes = propTypes;
ViewportController.defaultProps = defaultProps;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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