'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.testInitializeLayer = testInitializeLayer;
exports.testUpdateLayer = testUpdateLayer;
exports.testDrawLayer = testDrawLayer;
exports.testLayer = testLayer;

var _deck = require('deck.gl');

var _test = require('probe.gl/test');

var _setupGl = require('./utils/setup-gl');

var _setupGl2 = _interopRequireDefault(_setupGl);

function _interopRequireDefault(obj) {
  return obj && obj.__esModule ? obj : { default: obj };
}

var MapView = _deck.experimental.MapView; // Copyright (c) 2015 - 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

function checkDoesNotThrow(func, comment, userData) {
  try {
    return func();
  } catch (error) {
    return error;
  }
}

function testInitializeLayer(_ref) {
  var layer = _ref.layer,
      viewport = _ref.viewport;

  var layerManager = new _deck.LayerManager(_setupGl2.default);

  try {
    layerManager.setLayers([layer]);
  } catch (error) {
    return error;
  }

  return null;
}

function testUpdateLayer(_ref2) {
  var layer = _ref2.layer,
      viewport = _ref2.viewport,
      newProps = _ref2.newProps;

  var layerManager = new _deck.LayerManager(_setupGl2.default);

  try {
    layerManager.setLayers([layer]);
    layerManager.setLayers([layer.clone(newProps)]);
  } catch (error) {
    return error;
  }

  return null;
}

function testDrawLayer(_ref3) {
  var layer = _ref3.layer,
      _ref3$uniforms = _ref3.uniforms,
      uniforms = _ref3$uniforms === undefined ? {} : _ref3$uniforms;

  var layerManager = new _deck.LayerManager(_setupGl2.default);

  try {
    layerManager.setLayers([layer]);
    layerManager.drawLayers();
  } catch (error) {
    return error;
  }

  return null;
}

function testLayer(_ref4) {
  var Layer = _ref4.Layer,
      _ref4$testCases = _ref4.testCases,
      testCases = _ref4$testCases === undefined ? [] : _ref4$testCases,
      _ref4$spies = _ref4.spies,
      spies = _ref4$spies === undefined ? [] : _ref4$spies,
      _ref4$userData = _ref4.userData,
      userData = _ref4$userData === undefined ? null : _ref4$userData,
      _ref4$doesNotThrow = _ref4.doesNotThrow,
      doesNotThrow = _ref4$doesNotThrow === undefined ? checkDoesNotThrow : _ref4$doesNotThrow;

  // assert(Layer);

  var layerManager = new _deck.LayerManager(_setupGl2.default);
  layerManager.setViews([new MapView()]);

  var initialProps = testCases[0].props;
  var layer = new Layer(initialProps);

  doesNotThrow(function () {
    return layerManager.setLayers([layer]);
  }, 'initialization of ' + Layer.layerName + ' should not fail', userData);

  runLayerTests(layerManager, layer, testCases, spies, userData, doesNotThrow);
}

/* eslint-disable max-params, no-loop-func */
function runLayerTests(layerManager, layer, testCases, spies, userData, doesNotThrow) {
  var combinedProps = {};

  // Run successive update tests

  var _loop = function _loop(i) {
    var _testCases$i = testCases[i],
        props = _testCases$i.props,
        updateProps = _testCases$i.updateProps,
        assert = _testCases$i.assert;

    spies = testCases[i].spies || spies;

    // Create a map of spies that the test case can inspect
    var spyMap = {};
    if (spies) {
      var _iteratorNormalCompletion = true;
      var _didIteratorError = false;
      var _iteratorError = undefined;

      try {
        for (var _iterator = spies[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
          var functionName = _step.value;

          spyMap[functionName] = (0, _test.makeSpy)(Object.getPrototypeOf(layer), functionName);
        }
      } catch (err) {
        _didIteratorError = true;
        _iteratorError = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion && _iterator.return) {
            _iterator.return();
          }
        } finally {
          if (_didIteratorError) {
            throw _iteratorError;
          }
        }
      }
    }

    // Test case can reset the props on every iteration
    if (props) {
      combinedProps = Object.assign({}, props);
    }
    // Test case can override with new props on every iteration
    if (updateProps) {
      Object.assign(combinedProps, updateProps);
    }

    // copy old state before update
    var oldState = Object.assign({}, layer.state);

    layer = layer.clone(combinedProps);
    doesNotThrow(function () {
      return layerManager.setLayers([layer]);
    }, 'update ' + layer + ' should not fail', userData);

    // call draw layer
    doesNotThrow(function () {
      return layerManager.drawLayers();
    }, 'draw ' + layer + ' should not fail', userData);

    // layer manager should handle match subLayer and tranfer state and props
    // here we assume subLayer matches copy over the new props from a new subLayer
    var subLayers = layer.isComposite ? layer.getSubLayers() : [];
    var subLayer = subLayers.length && subLayers[0];

    // assert on updated layer
    if (assert) {
      assert({ layer: layer, oldState: oldState, subLayers: subLayers, subLayer: subLayer, spies: spyMap, userData: userData });
    }

    // Remove spies
    Object.keys(spyMap).forEach(function (k) {
      return spyMap[k].reset();
    });
  };

  for (var i = 0; i < testCases.length; i++) {
    _loop(i);
  }
}
/* eslint-enable parameters, no-loop-func */
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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