'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _slicedToArray = function () {
  function sliceIterator(arr, i) {
    var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;_e = err;
    } finally {
      try {
        if (!_n && _i["return"]) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }return _arr;
  }return function (arr, i) {
    if (Array.isArray(arr)) {
      return arr;
    } else if (Symbol.iterator in Object(arr)) {
      return sliceIterator(arr, i);
    } else {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }
  };
}();

exports.loadModel = loadModel;
exports.parseModel = parseModel;

var _browserLoadFile = require('./browser-load-file');

var _webgl = require('../webgl');

var _core = require('../core');

var _geometry = require('../geometry');

// Loads a simple JSON format
function loadModel(gl) {
  var opts = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

  return (0, _browserLoadFile.loadFile)(opts).then(function (_ref) {
    var _ref2 = _slicedToArray(_ref, 1),
        file = _ref2[0];

    return parseModel(gl, Object.assign({ file: file }, opts));
  });
}

function parseModel(gl) {
  var opts = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var file = opts.file,
      _opts$program = opts.program,
      program = _opts$program === undefined ? new _webgl.Program(gl) : _opts$program;

  var json = typeof file === 'string' ? parseJSON(file) : file;
  // Remove any attributes so that we can create a geometry
  // TODO - change format to put these in geometry sub object?
  var attributes = {};
  var modelOptions = {};
  for (var key in json) {
    var value = json[key];
    if (Array.isArray(value)) {
      attributes[key] = key === 'indices' ? new Uint16Array(value) : new Float32Array(value);
    } else {
      modelOptions[key] = value;
    }
  }

  return new _core.Model(gl, Object.assign({ program: program, geometry: new _geometry.Geometry({ attributes: attributes }) }, modelOptions, opts));
}

function parseJSON(file) {
  try {
    return JSON.parse(file);
  } catch (error) {
    throw new Error('Failed to parse JSON: ' + error);
  }
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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