'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _slicedToArray = function () {
  function sliceIterator(arr, i) {
    var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;_e = err;
    } finally {
      try {
        if (!_n && _i["return"]) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }return _arr;
  }return function (arr, i) {
    if (Array.isArray(arr)) {
      return arr;
    } else if (Symbol.iterator in Object(arr)) {
      return sliceIterator(arr, i);
    } else {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }
  };
}();

exports.loadTexture = loadTexture;
exports.loadProgram = loadProgram;
exports.loadTextures = loadTextures;

var _loadFiles = require('./load-files');

var _webgl = require('../webgl');

var _assert = require('assert');

var _assert2 = _interopRequireDefault(_assert);

function _interopRequireDefault(obj) {
  return obj && obj.__esModule ? obj : { default: obj };
}

function noop() {}

function loadTexture(gl, url) {
  var opts = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
  var urls = opts.urls,
      _opts$onProgress = opts.onProgress,
      onProgress = _opts$onProgress === undefined ? noop : _opts$onProgress;

  (0, _assert2.default)(typeof url === 'string', 'loadTexture: url must be string');

  return (0, _loadFiles.loadImages)(Object.assign({ urls: urls, onProgress: onProgress }, opts)).then(function (images) {
    return images.map(function (img, i) {
      return new _webgl.Texture2D(gl, Object.assign({ id: urls[i] }, opts, { data: img }));
    });
  });
}

function loadProgram(gl) {
  var opts = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var vs = opts.vs,
      fs = opts.fs,
      _opts$onProgress2 = opts.onProgress,
      onProgress = _opts$onProgress2 === undefined ? noop : _opts$onProgress2;

  return (0, _loadFiles.loadFiles)(Object.assign({ urls: [vs, fs], onProgress: onProgress }, opts)).then(function (_ref) {
    var _ref2 = _slicedToArray(_ref, 2),
        vsText = _ref2[0],
        fsText = _ref2[1];

    return new _webgl.Program(gl, Object.assign({ vs: vsText, fs: fsText }, opts));
  });
}

function loadTextures(gl) {
  var opts = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var urls = opts.urls,
      _opts$onProgress3 = opts.onProgress,
      onProgress = _opts$onProgress3 === undefined ? noop : _opts$onProgress3;

  (0, _assert2.default)(urls.every(function (url) {
    return typeof url === 'string';
  }), 'loadTextures: {urls} must be array of strings');

  return (0, _loadFiles.loadImages)(Object.assign({ urls: urls, onProgress: onProgress }, opts)).then(function (images) {
    return images.map(function (img, i) {
      var params = Array.isArray(opts.parameters) ? opts.parameters[i] : opts.parameters;
      params = params === undefined ? {} : params;
      return new _webgl.Texture2D(gl, Object.assign({ id: urls[i] }, params, { data: img }));
    });
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uLy4uL3NyYy9sdW1hLmdsL2lvLWJhc2ljL2xvYWQtdGV4dHVyZS5qcyJdLCJuYW1lcyI6WyJsb2FkVGV4dHVyZSIsImxvYWRQcm9ncmFtIiwibG9hZFRleHR1cmVzIiwibm9vcCIsImdsIiwidXJsIiwib3B0cyIsInVybHMiLCJvblByb2dyZXNzIiwiT2JqZWN0IiwiYXNzaWduIiwidGhlbiIsImltYWdlcyIsIm1hcCIsImltZyIsImkiLCJpZCIsImRhdGEiLCJ2cyIsImZzIiwidnNUZXh0IiwiZnNUZXh0IiwiZXZlcnkiLCJwYXJhbXMiLCJBcnJheSIsImlzQXJyYXkiLCJwYXJhbWV0ZXJzIiwidW5kZWZpbmVkIl0sIm1hcHBpbmdzIjoiOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OztRQU1nQixBLGMsQUFBQTtRLEFBV0EsY0FBQSxBO1EsQUFPQSxlLEFBQUE7O0FBeEJoQjs7QUFDQTs7QUFDQTs7Ozs7Ozs7QUFFQSxTQUFBLEFBQVMsT0FBTyxBQUFFOztBQUVYLFNBQUEsQUFBUyxZQUFULEFBQXFCLElBQXJCLEFBQXlCLEtBQWdCO01BQVgsQUFBVywyRUFBSixBQUFJO01BQUEsQUFDdkMsT0FEdUMsQUFDWixLQURZLEFBQ3ZDO3lCQUR1QyxBQUNaLEtBRFksQUFDakM7TUFEaUMsQUFDakMsOENBRGlDLEFBQ3BCLE9BQzFCOzt3QkFBTyxPQUFBLEFBQU8sUUFBZCxBQUFzQixVQUF0QixBQUFnQyxBQUVoQzs7b0NBQWtCLE9BQUEsQUFBTyxPQUFPLEVBQUMsTUFBRCxNQUFPLFlBQXJCLEFBQWMsY0FBekIsQUFBVyxBQUFrQyxPQUE3QyxBQUFvRCxLQUFLLGtCQUFBO2tCQUM5RCxBQUFPLElBQUksVUFBQSxBQUFDLEtBQUQsQUFBTSxHQUFNLEFBQ3JCO2FBQU8scUJBQUEsQUFBYyxJQUFJLE9BQUEsQUFBTyxPQUFPLEVBQUMsSUFBSSxLQUFuQixBQUFjLEFBQUssQUFBSyxNQUF4QixBQUE2QixNQUFNLEVBQUMsTUFBN0QsQUFBTyxBQUFrQixBQUFtQyxBQUFPLEFBQ3BFO0FBSDZELEFBQzlELEtBQUE7QUFERixBQUFPLEFBS1IsR0FMUTs7O0FBT0YsU0FBQSxBQUFTLFlBQVQsQUFBcUIsSUFBZTtNQUFYLEFBQVcsMkVBQUosQUFBSTtNQUFBLEFBQ2xDLEtBRGtDLEFBQ0wsS0FESyxBQUNsQztNQURrQyxBQUM5QixLQUQ4QixBQUNMLEtBREssQUFDOUI7MEJBRDhCLEFBQ0wsS0FESyxBQUMxQjtNQUQwQixBQUMxQiwrQ0FEMEIsQUFDYixPQUM1Qjs7bUNBQWlCLE9BQUEsQUFBTyxPQUFPLEVBQUMsTUFBTSxDQUFBLEFBQUMsSUFBUixBQUFPLEFBQUssS0FBSyxZQUEvQixBQUFjLGNBQXhCLEFBQVUsQUFBNEMsT0FBdEQsQUFBNkQsS0FDbEUsZ0JBQUE7cUNBQUE7UUFBQSxBQUFFLGVBQUY7UUFBQSxBQUFVLGVBQVY7O1dBQXNCLG1CQUFBLEFBQVksSUFBSSxPQUFBLEFBQU8sT0FBTyxFQUFDLElBQUQsQUFBSyxRQUFRLElBQTNCLEFBQWMsQUFBaUIsVUFBckUsQUFBc0IsQUFBZ0IsQUFBd0M7QUFEaEYsQUFBTyxBQUdSLEdBSFE7OztBQUtGLFNBQUEsQUFBUyxhQUFULEFBQXNCLElBQWU7TUFBWCxBQUFXLDJFQUFKLEFBQUk7TUFBQSxBQUNuQyxPQURtQyxBQUNSLEtBRFEsQUFDbkM7MEJBRG1DLEFBQ1IsS0FEUSxBQUM3QjtNQUQ2QixBQUM3QiwrQ0FENkIsQUFDaEIsT0FDMUI7OzZCQUNFLEFBQUssTUFBTSxlQUFBO1dBQU8sT0FBQSxBQUFPLFFBQWQsQUFBc0I7QUFEbkMsQUFDRSxHQUFBLEdBREYsQUFFRSxBQUdGOztvQ0FBa0IsT0FBQSxBQUFPLE9BQU8sRUFBQyxNQUFELE1BQU8sWUFBckIsQUFBYyxjQUF6QixBQUFXLEFBQWtDLE9BQTdDLEFBQW9ELEtBQUssa0JBQUE7a0JBQzlELEFBQU8sSUFBSSxVQUFBLEFBQUMsS0FBRCxBQUFNLEdBQU0sQUFDckI7VUFBSSxTQUFTLE1BQUEsQUFBTSxRQUFRLEtBQWQsQUFBbUIsY0FBYyxLQUFBLEFBQUssV0FBdEMsQUFBaUMsQUFBZ0IsS0FBSyxLQUFuRSxBQUF3RSxBQUN4RTtlQUFTLFdBQUEsQUFBVyxZQUFYLEFBQXVCLEtBQWhDLEFBQXFDLEFBQ3JDO2FBQU8scUJBQUEsQUFBYyxJQUFJLE9BQUEsQUFBTyxPQUFPLEVBQUMsSUFBSSxLQUFuQixBQUFjLEFBQUssQUFBSyxNQUF4QixBQUE2QixRQUFRLEVBQUMsTUFBL0QsQUFBTyxBQUFrQixBQUFxQyxBQUFPLEFBQ3RFO0FBTDZELEFBQzlELEtBQUE7QUFERixBQUFPLEFBT1IsR0FQUSIsImZpbGUiOiJsb2FkLXRleHR1cmUuanMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQge2xvYWRGaWxlcywgbG9hZEltYWdlc30gZnJvbSAnLi9sb2FkLWZpbGVzJztcbmltcG9ydCB7UHJvZ3JhbSwgVGV4dHVyZTJEfSBmcm9tICcuLi93ZWJnbCc7XG5pbXBvcnQgYXNzZXJ0IGZyb20gJ2Fzc2VydCc7XG5cbmZ1bmN0aW9uIG5vb3AoKSB7fVxuXG5leHBvcnQgZnVuY3Rpb24gbG9hZFRleHR1cmUoZ2wsIHVybCwgb3B0cyA9IHt9KSB7XG4gIGNvbnN0IHt1cmxzLCBvblByb2dyZXNzID0gbm9vcH0gPSBvcHRzO1xuICBhc3NlcnQodHlwZW9mIHVybCA9PT0gJ3N0cmluZycsICdsb2FkVGV4dHVyZTogdXJsIG11c3QgYmUgc3RyaW5nJyk7XG5cbiAgcmV0dXJuIGxvYWRJbWFnZXMoT2JqZWN0LmFzc2lnbih7dXJscywgb25Qcm9ncmVzc30sIG9wdHMpKS50aGVuKGltYWdlcyA9PlxuICAgIGltYWdlcy5tYXAoKGltZywgaSkgPT4ge1xuICAgICAgcmV0dXJuIG5ldyBUZXh0dXJlMkQoZ2wsIE9iamVjdC5hc3NpZ24oe2lkOiB1cmxzW2ldfSwgb3B0cywge2RhdGE6IGltZ30pKTtcbiAgICB9KVxuICApO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gbG9hZFByb2dyYW0oZ2wsIG9wdHMgPSB7fSkge1xuICBjb25zdCB7dnMsIGZzLCBvblByb2dyZXNzID0gbm9vcH0gPSBvcHRzO1xuICByZXR1cm4gbG9hZEZpbGVzKE9iamVjdC5hc3NpZ24oe3VybHM6IFt2cywgZnNdLCBvblByb2dyZXNzfSwgb3B0cykpLnRoZW4oXG4gICAgKFt2c1RleHQsIGZzVGV4dF0pID0+IG5ldyBQcm9ncmFtKGdsLCBPYmplY3QuYXNzaWduKHt2czogdnNUZXh0LCBmczogZnNUZXh0fSwgb3B0cykpXG4gICk7XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBsb2FkVGV4dHVyZXMoZ2wsIG9wdHMgPSB7fSkge1xuICBjb25zdCB7dXJscywgb25Qcm9ncmVzcyA9IG5vb3B9ID0gb3B0cztcbiAgYXNzZXJ0KFxuICAgIHVybHMuZXZlcnkodXJsID0+IHR5cGVvZiB1cmwgPT09ICdzdHJpbmcnKSxcbiAgICAnbG9hZFRleHR1cmVzOiB7dXJsc30gbXVzdCBiZSBhcnJheSBvZiBzdHJpbmdzJ1xuICApO1xuXG4gIHJldHVybiBsb2FkSW1hZ2VzKE9iamVjdC5hc3NpZ24oe3VybHMsIG9uUHJvZ3Jlc3N9LCBvcHRzKSkudGhlbihpbWFnZXMgPT5cbiAgICBpbWFnZXMubWFwKChpbWcsIGkpID0+IHtcbiAgICAgIGxldCBwYXJhbXMgPSBBcnJheS5pc0FycmF5KG9wdHMucGFyYW1ldGVycykgPyBvcHRzLnBhcmFtZXRlcnNbaV0gOiBvcHRzLnBhcmFtZXRlcnM7XG4gICAgICBwYXJhbXMgPSBwYXJhbXMgPT09IHVuZGVmaW5lZCA/IHt9IDogcGFyYW1zO1xuICAgICAgcmV0dXJuIG5ldyBUZXh0dXJlMkQoZ2wsIE9iamVjdC5hc3NpZ24oe2lkOiB1cmxzW2ldfSwgcGFyYW1zLCB7ZGF0YTogaW1nfSkpO1xuICAgIH0pXG4gICk7XG59XG4iXX0=