'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.compressImage = compressImage;
// Use stackgl modules for DOM-less reading and writing of images
// NOTE: These are not dependencies of luma.gl.
// They need to be imported by the app.

/**
 * Returns data bytes representing a compressed image in PNG or JPG format,
 * This data can be saved using file system (f) methods or
 * used in a request.
 * @param {Image} image to save
 * @param {String} type='png' - png, jpg or image/png, image/jpg are valid
 * @param {String} opt.dataURI= - Whether to include a data URI header
 * @return {*} bytes
 */
function compressImage(image) {
  var type = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'png';

  var savePixels = module.require('save-pixels');
  var ndarray = module.require('ndarray');
  if (!savePixels || !ndarray) {
    throw new Error('compressImage: save-pixels or ndarray not installed');
  }

  var pixels = ndarray(image.data, [image.width, image.height, 4], [4, image.width * 4, 1], 0);

  // TODO - does this return stream?
  return savePixels(pixels, type.replace('image/', ''));
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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