'use strict';

var _typeof2 = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _typeof = typeof Symbol === "function" && _typeof2(Symbol.iterator) === "symbol" ? function (obj) {
  return typeof obj === "undefined" ? "undefined" : _typeof2(obj);
} : function (obj) {
  return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj === "undefined" ? "undefined" : _typeof2(obj);
};

exports.toLowPrecision = toLowPrecision;
/**
 * Covert all numbers in a deep structure to a given precision, allowing
 * reliable float comparisons. Converts data in-place.
 * @param  {mixed} input      Input data
 * @param  {Number} [precision] Desired precision
 * @return {mixed}            Input data, with all numbers converted
 */
function toLowPrecision(input) {
  var precision = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 11;

  /* eslint-disable guard-for-in */
  if (typeof input === 'number') {
    input = Number(input.toPrecision(precision));
  }
  if (Array.isArray(input)) {
    input = input.map(function (item) {
      return toLowPrecision(item, precision);
    });
  }
  if ((typeof input === 'undefined' ? 'undefined' : _typeof(input)) === 'object') {
    for (var key in input) {
      input[key] = toLowPrecision(input[key], precision);
    }
  }
  return input;
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy91dGlscy9wcmVjaXNpb24uanMiXSwibmFtZXMiOlsidG9Mb3dQcmVjaXNpb24iLCJpbnB1dCIsInByZWNpc2lvbiIsIk51bWJlciIsInRvUHJlY2lzaW9uIiwiQXJyYXkiLCJpc0FycmF5IiwibWFwIiwiaXRlbSIsImtleSJdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7Ozs7Ozs7UUFPZ0IsQSxpQixBQUFBO0FBUGhCOzs7Ozs7O0FBT08sU0FBQSxBQUFTLGVBQVQsQUFBd0IsT0FBdUI7TUFBaEIsQUFBZ0IsZ0ZBQUosQUFBSSxBQUNwRDs7QUFDQTtNQUFJLE9BQUEsQUFBTyxVQUFYLEFBQXFCLFVBQVUsQUFDN0I7WUFBUSxPQUFPLE1BQUEsQUFBTSxZQUFyQixBQUFRLEFBQU8sQUFBa0IsQUFDbEM7QUFDRDtNQUFJLE1BQUEsQUFBTSxRQUFWLEFBQUksQUFBYyxRQUFRLEFBQ3hCO2tCQUFRLEFBQU0sSUFBSSxnQkFBQTthQUFRLGVBQUEsQUFBZSxNQUF2QixBQUFRLEFBQXFCO0FBQS9DLEFBQVEsQUFDVCxLQURTO0FBRVY7TUFBSSxRQUFBLEFBQU8sOENBQVAsQUFBTyxZQUFYLEFBQXFCLFVBQVUsQUFDN0I7U0FBSyxJQUFMLEFBQVcsT0FBWCxBQUFrQixPQUFPLEFBQ3ZCO1lBQUEsQUFBTSxPQUFPLGVBQWUsTUFBZixBQUFlLEFBQU0sTUFBbEMsQUFBYSxBQUEyQixBQUN6QztBQUNGO0FBQ0Q7U0FBQSxBQUFPLEFBQ1IiLCJmaWxlIjoicHJlY2lzaW9uLmpzIiwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiBDb3ZlcnQgYWxsIG51bWJlcnMgaW4gYSBkZWVwIHN0cnVjdHVyZSB0byBhIGdpdmVuIHByZWNpc2lvbiwgYWxsb3dpbmdcbiAqIHJlbGlhYmxlIGZsb2F0IGNvbXBhcmlzb25zLiBDb252ZXJ0cyBkYXRhIGluLXBsYWNlLlxuICogQHBhcmFtICB7bWl4ZWR9IGlucHV0ICAgICAgSW5wdXQgZGF0YVxuICogQHBhcmFtICB7TnVtYmVyfSBbcHJlY2lzaW9uXSBEZXNpcmVkIHByZWNpc2lvblxuICogQHJldHVybiB7bWl4ZWR9ICAgICAgICAgICAgSW5wdXQgZGF0YSwgd2l0aCBhbGwgbnVtYmVycyBjb252ZXJ0ZWRcbiAqL1xuZXhwb3J0IGZ1bmN0aW9uIHRvTG93UHJlY2lzaW9uKGlucHV0LCBwcmVjaXNpb24gPSAxMSkge1xuICAvKiBlc2xpbnQtZGlzYWJsZSBndWFyZC1mb3ItaW4gKi9cbiAgaWYgKHR5cGVvZiBpbnB1dCA9PT0gJ251bWJlcicpIHtcbiAgICBpbnB1dCA9IE51bWJlcihpbnB1dC50b1ByZWNpc2lvbihwcmVjaXNpb24pKTtcbiAgfVxuICBpZiAoQXJyYXkuaXNBcnJheShpbnB1dCkpIHtcbiAgICBpbnB1dCA9IGlucHV0Lm1hcChpdGVtID0+IHRvTG93UHJlY2lzaW9uKGl0ZW0sIHByZWNpc2lvbikpO1xuICB9XG4gIGlmICh0eXBlb2YgaW5wdXQgPT09ICdvYmplY3QnKSB7XG4gICAgZm9yIChjb25zdCBrZXkgaW4gaW5wdXQpIHtcbiAgICAgIGlucHV0W2tleV0gPSB0b0xvd1ByZWNpc2lvbihpbnB1dFtrZXldLCBwcmVjaXNpb24pO1xuICAgIH1cbiAgfVxuICByZXR1cm4gaW5wdXQ7XG59XG4iXX0=