var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

import { getPathPrefix } from './path-prefix';

export function loadFile(url, opts) {
  if (typeof url !== 'string' && !opts) {
    // TODO - warn for deprecated mode
    opts = url;
    url = opts.url;
  }
  var pathPrefix = getPathPrefix();
  opts.url = pathPrefix ? pathPrefix + url : url;
  return requestFile(opts);
}

// Supports loading (requesting) assets with XHR (XmlHttpRequest)
/* eslint-disable guard-for-in, complexity, no-try-catch */

/* global XMLHttpRequest */
function noop() {}

var XHR_STATES = {
  UNINITIALIZED: 0,
  LOADING: 1,
  LOADED: 2,
  INTERACTIVE: 3,
  COMPLETED: 4
};

var XHR = function () {
  function XHR(_ref) {
    var url = _ref.url,
        _ref$path = _ref.path,
        path = _ref$path === undefined ? null : _ref$path,
        _ref$method = _ref.method,
        method = _ref$method === undefined ? 'GET' : _ref$method,
        _ref$asynchronous = _ref.asynchronous,
        asynchronous = _ref$asynchronous === undefined ? true : _ref$asynchronous,
        _ref$noCache = _ref.noCache,
        noCache = _ref$noCache === undefined ? false : _ref$noCache,
        _ref$sendAsBinary = _ref.sendAsBinary,
        sendAsBinary = _ref$sendAsBinary === undefined ? false : _ref$sendAsBinary,
        _ref$responseType = _ref.responseType,
        responseType = _ref$responseType === undefined ? false : _ref$responseType,
        _ref$onProgress = _ref.onProgress,
        onProgress = _ref$onProgress === undefined ? noop : _ref$onProgress,
        _ref$onError = _ref.onError,
        onError = _ref$onError === undefined ? noop : _ref$onError,
        _ref$onAbort = _ref.onAbort,
        onAbort = _ref$onAbort === undefined ? noop : _ref$onAbort,
        _ref$onComplete = _ref.onComplete,
        onComplete = _ref$onComplete === undefined ? noop : _ref$onComplete;

    _classCallCheck(this, XHR);

    this.url = path ? path.join(path, url) : url;
    this.method = method;
    this.async = asynchronous;
    this.noCache = noCache;
    this.sendAsBinary = sendAsBinary;
    this.responseType = responseType;

    this.req = new XMLHttpRequest();

    this.req.onload = function (e) {
      return onComplete(e);
    };
    this.req.onerror = function (e) {
      return onError(e);
    };
    this.req.onabort = function (e) {
      return onAbort(e);
    };
    this.req.onprogress = function (e) {
      if (e.lengthComputable) {
        onProgress(e, Math.round(e.loaded / e.total * 100));
      } else {
        onProgress(e, -1);
      }
    };
  }

  _createClass(XHR, [{
    key: 'setRequestHeader',
    value: function setRequestHeader(header, value) {
      this.req.setRequestHeader(header, value);
      return this;
    }

    // /* eslint-disable max-statements */

  }, {
    key: 'sendAsync',
    value: function sendAsync() {
      var _this = this;

      var body = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : this.body || null;

      return new Promise(function (resolve, reject) {
        try {
          var req = _this.req,
              method = _this.method,
              noCache = _this.noCache,
              sendAsBinary = _this.sendAsBinary,
              responseType = _this.responseType;


          var url = noCache ? _this.url + (_this.url.indexOf('?') >= 0 ? '&' : '?') + Date.now() : _this.url;

          req.open(method, url, _this.async);

          if (responseType) {
            req.responseType = responseType;
          }

          if (_this.async) {
            req.onreadystatechange = function (e) {
              if (req.readyState === XHR_STATES.COMPLETED) {
                if (req.status === 200) {
                  resolve(req.responseType ? req.response : req.responseText);
                } else {
                  reject(new Error(req.status + ': ' + url));
                }
              }
            };
          }

          if (sendAsBinary) {
            req.sendAsBinary(body);
          } else {
            req.send(body);
          }

          if (!_this.async) {
            if (req.status === 200) {
              resolve(req.responseType ? req.response : req.responseText);
            } else {
              reject(new Error(req.status + ': ' + url));
            }
          }
        } catch (error) {
          reject(error);
        }
      });
    }
    /* eslint-enable max-statements */

  }]);

  return XHR;
}();

export function requestFile(opts) {
  var xhr = new XHR(opts);
  return xhr.sendAsync();
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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