import { isBrowser } from '../utils/globals';
export { setPathPrefix } from './set-path-prefix';

// Call a require based helper to select platform to export
if (isBrowser) {
  module.exports.loadFile = require('browser-request-file');
  module.exports.loadImage = require('browser-request-image');
  module.exports.readFile = require('browser-read-file');
} else {
  var fs = module.require('fs');
  // TODO - needs to be promisified...
  module.exports.readFile = fs && fs.readFile;
}

export { loadFiles, loadImages } from './load-files';
export { loadTextures, loadProgram } from './load-textures';
export { loadModel, parseModel } from './json-loader';
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL3NyYy90ZXN0LXV0aWxzL2x1bWEuZ2wvaW8tYmFzaWMvaW5kZXguanMiXSwibmFtZXMiOlsiaXNCcm93c2VyIiwic2V0UGF0aFByZWZpeCIsIm1vZHVsZSIsImV4cG9ydHMiLCJsb2FkRmlsZSIsInJlcXVpcmUiLCJsb2FkSW1hZ2UiLCJyZWFkRmlsZSIsImZzIiwibG9hZEZpbGVzIiwibG9hZEltYWdlcyIsImxvYWRUZXh0dXJlcyIsImxvYWRQcm9ncmFtIiwibG9hZE1vZGVsIiwicGFyc2VNb2RlbCJdLCJtYXBwaW5ncyI6IkFBQUEsU0FBUUEsU0FBUixRQUF3QixrQkFBeEI7QUFDQSxTQUFRQyxhQUFSLFFBQTRCLG1CQUE1Qjs7QUFFQTtBQUNBLElBQUlELFNBQUosRUFBZTtBQUNiRSxTQUFPQyxPQUFQLENBQWVDLFFBQWYsR0FBMEJDLFFBQVEsc0JBQVIsQ0FBMUI7QUFDQUgsU0FBT0MsT0FBUCxDQUFlRyxTQUFmLEdBQTJCRCxRQUFRLHVCQUFSLENBQTNCO0FBQ0FILFNBQU9DLE9BQVAsQ0FBZUksUUFBZixHQUEwQkYsUUFBUSxtQkFBUixDQUExQjtBQUNELENBSkQsTUFJTztBQUNMLE1BQU1HLEtBQUtOLE9BQU9HLE9BQVAsQ0FBZSxJQUFmLENBQVg7QUFDQTtBQUNBSCxTQUFPQyxPQUFQLENBQWVJLFFBQWYsR0FBMEJDLE1BQU1BLEdBQUdELFFBQW5DO0FBQ0Q7O0FBRUQsU0FBUUUsU0FBUixFQUFtQkMsVUFBbkIsUUFBb0MsY0FBcEM7QUFDQSxTQUFRQyxZQUFSLEVBQXNCQyxXQUF0QixRQUF3QyxpQkFBeEM7QUFDQSxTQUFRQyxTQUFSLEVBQW1CQyxVQUFuQixRQUFvQyxlQUFwQyIsImZpbGUiOiJpbmRleC5qcyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7aXNCcm93c2VyfSBmcm9tICcuLi91dGlscy9nbG9iYWxzJztcbmV4cG9ydCB7c2V0UGF0aFByZWZpeH0gZnJvbSAnLi9zZXQtcGF0aC1wcmVmaXgnO1xuXG4vLyBDYWxsIGEgcmVxdWlyZSBiYXNlZCBoZWxwZXIgdG8gc2VsZWN0IHBsYXRmb3JtIHRvIGV4cG9ydFxuaWYgKGlzQnJvd3Nlcikge1xuICBtb2R1bGUuZXhwb3J0cy5sb2FkRmlsZSA9IHJlcXVpcmUoJ2Jyb3dzZXItcmVxdWVzdC1maWxlJyk7XG4gIG1vZHVsZS5leHBvcnRzLmxvYWRJbWFnZSA9IHJlcXVpcmUoJ2Jyb3dzZXItcmVxdWVzdC1pbWFnZScpO1xuICBtb2R1bGUuZXhwb3J0cy5yZWFkRmlsZSA9IHJlcXVpcmUoJ2Jyb3dzZXItcmVhZC1maWxlJyk7XG59IGVsc2Uge1xuICBjb25zdCBmcyA9IG1vZHVsZS5yZXF1aXJlKCdmcycpO1xuICAvLyBUT0RPIC0gbmVlZHMgdG8gYmUgcHJvbWlzaWZpZWQuLi5cbiAgbW9kdWxlLmV4cG9ydHMucmVhZEZpbGUgPSBmcyAmJiBmcy5yZWFkRmlsZTtcbn1cblxuZXhwb3J0IHtsb2FkRmlsZXMsIGxvYWRJbWFnZXN9IGZyb20gJy4vbG9hZC1maWxlcyc7XG5leHBvcnQge2xvYWRUZXh0dXJlcywgbG9hZFByb2dyYW19IGZyb20gJy4vbG9hZC10ZXh0dXJlcyc7XG5leHBvcnQge2xvYWRNb2RlbCwgcGFyc2VNb2RlbH0gZnJvbSAnLi9qc29uLWxvYWRlcic7XG4iXX0=