var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

import { loadFiles, loadImages } from './load-files';
import { Program, Texture2D } from '../webgl';
import assert from 'assert';

function noop() {}

export function loadTexture(gl, url) {
  var opts = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
  var urls = opts.urls,
      _opts$onProgress = opts.onProgress,
      onProgress = _opts$onProgress === undefined ? noop : _opts$onProgress;

  assert(typeof url === 'string', 'loadTexture: url must be string');

  return loadImages(Object.assign({ urls: urls, onProgress: onProgress }, opts)).then(function (images) {
    return images.map(function (img, i) {
      return new Texture2D(gl, Object.assign({ id: urls[i] }, opts, { data: img }));
    });
  });
}

export function loadProgram(gl) {
  var opts = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var vs = opts.vs,
      fs = opts.fs,
      _opts$onProgress2 = opts.onProgress,
      onProgress = _opts$onProgress2 === undefined ? noop : _opts$onProgress2;

  return loadFiles(Object.assign({ urls: [vs, fs], onProgress: onProgress }, opts)).then(function (_ref) {
    var _ref2 = _slicedToArray(_ref, 2),
        vsText = _ref2[0],
        fsText = _ref2[1];

    return new Program(gl, Object.assign({ vs: vsText, fs: fsText }, opts));
  });
}

export function loadTextures(gl) {
  var opts = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var urls = opts.urls,
      _opts$onProgress3 = opts.onProgress,
      onProgress = _opts$onProgress3 === undefined ? noop : _opts$onProgress3;

  assert(urls.every(function (url) {
    return typeof url === 'string';
  }), 'loadTextures: {urls} must be array of strings');

  return loadImages(Object.assign({ urls: urls, onProgress: onProgress }, opts)).then(function (images) {
    return images.map(function (img, i) {
      var params = Array.isArray(opts.parameters) ? opts.parameters[i] : opts.parameters;
      params = params === undefined ? {} : params;
      return new Texture2D(gl, Object.assign({ id: urls[i] }, params, { data: img }));
    });
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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