// Use stackgl modules for DOM-less reading and writing of images
// NOTE: These are not dependencies of luma.gl.
// They need to be imported by the app.

/**
 * Returns data bytes representing a compressed image in PNG or JPG format,
 * This data can be saved using file system (f) methods or
 * used in a request.
 * @param {Image} image to save
 * @param {String} type='png' - png, jpg or image/png, image/jpg are valid
 * @param {String} opt.dataURI= - Whether to include a data URI header
 * @return {*} bytes
 */
export function compressImage(image) {
  var type = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'png';

  var savePixels = module.require('save-pixels');
  var ndarray = module.require('ndarray');
  if (!savePixels || !ndarray) {
    throw new Error('compressImage: save-pixels or ndarray not installed');
  }

  var pixels = ndarray(image.data, [image.width, image.height, 4], [4, image.width * 4, 1], 0);

  // TODO - does this return stream?
  return savePixels(pixels, type.replace('image/', ''));
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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