// Image loading/saving for browser
/* global document, HTMLCanvasElement, Image */

/* global process, Buffer */
import assert from 'assert';
import through from 'through'; // Note: through adds stream support

/*
 * Returns data bytes representing a compressed image in PNG or JPG format,
 * This data can be saved using file system (f) methods or
 * used in a request.
 * @param {Image}  image - Image or Canvas
 * @param {String} opt.type='png' - png, jpg or image/png, image/jpg are valid
 * @param {String} opt.dataURI= - Whether to include a data URI header
 */
export function compressImage(image, type) {
  if (image instanceof HTMLCanvasElement) {
    var _canvas = image;
    return _canvas.toDataURL(type);
  }

  assert(image instanceof Image, 'getImageData accepts image or canvas');
  var canvas = document.createElement('canvas');
  canvas.width = image.width;
  canvas.height = image.height;
  canvas.getContext('2d').drawImage(image, 0, 0);

  // Get raw image data
  var data = canvas.toDataURL(type || 'png').replace(/^data:image\/(png|jpg);base64,/, '');

  // Dump data into stream and return
  var result = through();
  process.nextTick(function () {
    return result.end(new Buffer(data, 'base64'));
  });
  return result;
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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