// A browser implementation of the Node.js `fs` module's `fs.writeFile` method.

import { isBrowser } from '../../utils';

// TODO hack - trick filesaver.js to skip loading under node
/* global global*/
var savedNavigatorExists = 'navigator' in global;
var savedNavigator = global.navigator;
if (!isBrowser) {
  global.navigator = { userAgent: 'MSIE 9.' };
}

// Need to use `require` to ensure our modification of global code above happens first
var saveAs = require('filesaver.js');

if (!isBrowser) {
  if (savedNavigatorExists) {
    global.navigator = savedNavigator;
  } else {
    delete global.navigator;
  }
}
// END hack

var window = require('global/window');
var Blob = window.Blob;

/**
 * File system write function for the browser, similar to Node's fs.writeFile
 *
 * Saves a file by downloading it with the given file name.
 *
 * @param {String} file - file name
 * @param {String|Blob} data - data to be written to file
 * @param {String|Object} options -
 * @param {Function} callback - Standard node (err, data) callback
 * @return {Promise} - promise, can be used instead of callback
 */
export function writeFile(file, data, options) {
  var callback = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : function () {};

  // options is optional
  if (callback === undefined && typeof options === 'function') {
    options = undefined;
    callback = options;
  }
  if (typeof data === 'string') {
    data = new Blob(data);
  }
  return new Promise(function (resolve, reject) {
    var result = void 0;
    try {
      result = saveAs(data, file, options);
    } catch (error) {
      reject(error);
      return callback(error, null);
    }
    resolve();
    return callback(null, result);
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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