"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
// Copyright (c) 2015 - 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

exports.default = "#define SHADER_NAME arc-layer-vertex-shader\n\nattribute vec3 positions;\nattribute vec4 instanceSourceColors;\nattribute vec4 instanceTargetColors;\nattribute vec4 instancePositions;\nattribute vec3 instancePickingColors;\n\nuniform float numSegments;\nuniform float strokeWidth;\nuniform float opacity;\n\nvarying vec4 vColor;\n\nfloat paraboloid(vec2 source, vec2 target, float ratio) {\n\n  vec2 x = mix(source, target, ratio);\n  vec2 center = mix(source, target, 0.5);\n\n  float dSourceCenter = distance(source, center);\n  float dXCenter = distance(x, center);\n  return (dSourceCenter + dXCenter) * (dSourceCenter - dXCenter);\n}\n\n// offset vector by strokeWidth pixels\n// offset_direction is -1 (left) or 1 (right)\nvec2 getExtrusionOffset(vec2 line_clipspace, float offset_direction) {\n  // normalized direction of the line\n  vec2 dir_screenspace = normalize(line_clipspace * project_uViewportSize);\n  // rotate by 90 degrees\n  dir_screenspace = vec2(-dir_screenspace.y, dir_screenspace.x);\n\n  vec2 offset_screenspace = dir_screenspace * offset_direction * strokeWidth / 2.0;\n  vec2 offset_clipspace = project_pixel_to_clipspace(offset_screenspace).xy;\n\n  return offset_clipspace;\n}\n\nfloat getSegmentRatio(float index) {\n  return smoothstep(0.0, 1.0, index / (numSegments - 1.0));\n}\n\nvec3 getPos(vec2 source, vec2 target, float segmentRatio) {\n  float vertex_height = paraboloid(source, target, segmentRatio);\n\n  return vec3(\n    mix(source, target, segmentRatio),\n    sqrt(max(0.0, vertex_height))\n  );\n}\n\nvoid main(void) {\n  vec2 source = project_position(instancePositions.xy);\n  vec2 target = project_position(instancePositions.zw);\n\n  float segmentIndex = positions.x;\n  float segmentRatio = getSegmentRatio(segmentIndex);\n  // if it's the first point, use next - current as direction\n  // otherwise use current - prev\n  float indexDir = mix(-1.0, 1.0, step(segmentIndex, 0.0));\n  float nextSegmentRatio = getSegmentRatio(segmentIndex + indexDir);\n\n  vec3 currPos = getPos(source, target, segmentRatio);\n  vec3 nextPos = getPos(source, target, nextSegmentRatio);\n  vec4 curr = project_to_clipspace(vec4(currPos, 1.0));\n  vec4 next = project_to_clipspace(vec4(nextPos, 1.0));\n\n  // extrude\n  vec2 offset = getExtrusionOffset((next.xy - curr.xy) * indexDir, positions.y);\n  gl_Position = curr + vec4(offset, 0.0, 0.0);\n\n  vec4 color = mix(instanceSourceColors, instanceTargetColors, segmentRatio) / 255.;\n  vColor = vec4(color.rgb, color.a * opacity);\n\n  // Set color to be rendered to picking fbo (also used to check for selection highlight).\n  picking_setPickingColor(instancePickingColors);\n}\n";
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uLy4uL3NyYy9jb3JlLWxheWVycy9hcmMtbGF5ZXIvYXJjLWxheWVyLXZlcnRleC5nbHNsLmpzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EiLCJmaWxlIjoiYXJjLWxheWVyLXZlcnRleC5nbHNsLmpzIiwic291cmNlc0NvbnRlbnQiOlsiLy8gQ29weXJpZ2h0IChjKSAyMDE1IC0gMjAxNyBVYmVyIFRlY2hub2xvZ2llcywgSW5jLlxuLy9cbi8vIFBlcm1pc3Npb24gaXMgaGVyZWJ5IGdyYW50ZWQsIGZyZWUgb2YgY2hhcmdlLCB0byBhbnkgcGVyc29uIG9idGFpbmluZyBhIGNvcHlcbi8vIG9mIHRoaXMgc29mdHdhcmUgYW5kIGFzc29jaWF0ZWQgZG9jdW1lbnRhdGlvbiBmaWxlcyAodGhlIFwiU29mdHdhcmVcIiksIHRvIGRlYWxcbi8vIGluIHRoZSBTb2Z0d2FyZSB3aXRob3V0IHJlc3RyaWN0aW9uLCBpbmNsdWRpbmcgd2l0aG91dCBsaW1pdGF0aW9uIHRoZSByaWdodHNcbi8vIHRvIHVzZSwgY29weSwgbW9kaWZ5LCBtZXJnZSwgcHVibGlzaCwgZGlzdHJpYnV0ZSwgc3VibGljZW5zZSwgYW5kL29yIHNlbGxcbi8vIGNvcGllcyBvZiB0aGUgU29mdHdhcmUsIGFuZCB0byBwZXJtaXQgcGVyc29ucyB0byB3aG9tIHRoZSBTb2Z0d2FyZSBpc1xuLy8gZnVybmlzaGVkIHRvIGRvIHNvLCBzdWJqZWN0IHRvIHRoZSBmb2xsb3dpbmcgY29uZGl0aW9uczpcbi8vXG4vLyBUaGUgYWJvdmUgY29weXJpZ2h0IG5vdGljZSBhbmQgdGhpcyBwZXJtaXNzaW9uIG5vdGljZSBzaGFsbCBiZSBpbmNsdWRlZCBpblxuLy8gYWxsIGNvcGllcyBvciBzdWJzdGFudGlhbCBwb3J0aW9ucyBvZiB0aGUgU29mdHdhcmUuXG4vL1xuLy8gVEhFIFNPRlRXQVJFIElTIFBST1ZJREVEIFwiQVMgSVNcIiwgV0lUSE9VVCBXQVJSQU5UWSBPRiBBTlkgS0lORCwgRVhQUkVTUyBPUlxuLy8gSU1QTElFRCwgSU5DTFVESU5HIEJVVCBOT1QgTElNSVRFRCBUTyBUSEUgV0FSUkFOVElFUyBPRiBNRVJDSEFOVEFCSUxJVFksXG4vLyBGSVRORVNTIEZPUiBBIFBBUlRJQ1VMQVIgUFVSUE9TRSBBTkQgTk9OSU5GUklOR0VNRU5ULiBJTiBOTyBFVkVOVCBTSEFMTCBUSEVcbi8vIEFVVEhPUlMgT1IgQ09QWVJJR0hUIEhPTERFUlMgQkUgTElBQkxFIEZPUiBBTlkgQ0xBSU0sIERBTUFHRVMgT1IgT1RIRVJcbi8vIExJQUJJTElUWSwgV0hFVEhFUiBJTiBBTiBBQ1RJT04gT0YgQ09OVFJBQ1QsIFRPUlQgT1IgT1RIRVJXSVNFLCBBUklTSU5HIEZST00sXG4vLyBPVVQgT0YgT1IgSU4gQ09OTkVDVElPTiBXSVRIIFRIRSBTT0ZUV0FSRSBPUiBUSEUgVVNFIE9SIE9USEVSIERFQUxJTkdTIElOXG4vLyBUSEUgU09GVFdBUkUuXG5cbmV4cG9ydCBkZWZhdWx0IGBcXFxuI2RlZmluZSBTSEFERVJfTkFNRSBhcmMtbGF5ZXItdmVydGV4LXNoYWRlclxuXG5hdHRyaWJ1dGUgdmVjMyBwb3NpdGlvbnM7XG5hdHRyaWJ1dGUgdmVjNCBpbnN0YW5jZVNvdXJjZUNvbG9ycztcbmF0dHJpYnV0ZSB2ZWM0IGluc3RhbmNlVGFyZ2V0Q29sb3JzO1xuYXR0cmlidXRlIHZlYzQgaW5zdGFuY2VQb3NpdGlvbnM7XG5hdHRyaWJ1dGUgdmVjMyBpbnN0YW5jZVBpY2tpbmdDb2xvcnM7XG5cbnVuaWZvcm0gZmxvYXQgbnVtU2VnbWVudHM7XG51bmlmb3JtIGZsb2F0IHN0cm9rZVdpZHRoO1xudW5pZm9ybSBmbG9hdCBvcGFjaXR5O1xuXG52YXJ5aW5nIHZlYzQgdkNvbG9yO1xuXG5mbG9hdCBwYXJhYm9sb2lkKHZlYzIgc291cmNlLCB2ZWMyIHRhcmdldCwgZmxvYXQgcmF0aW8pIHtcblxuICB2ZWMyIHggPSBtaXgoc291cmNlLCB0YXJnZXQsIHJhdGlvKTtcbiAgdmVjMiBjZW50ZXIgPSBtaXgoc291cmNlLCB0YXJnZXQsIDAuNSk7XG5cbiAgZmxvYXQgZFNvdXJjZUNlbnRlciA9IGRpc3RhbmNlKHNvdXJjZSwgY2VudGVyKTtcbiAgZmxvYXQgZFhDZW50ZXIgPSBkaXN0YW5jZSh4LCBjZW50ZXIpO1xuICByZXR1cm4gKGRTb3VyY2VDZW50ZXIgKyBkWENlbnRlcikgKiAoZFNvdXJjZUNlbnRlciAtIGRYQ2VudGVyKTtcbn1cblxuLy8gb2Zmc2V0IHZlY3RvciBieSBzdHJva2VXaWR0aCBwaXhlbHNcbi8vIG9mZnNldF9kaXJlY3Rpb24gaXMgLTEgKGxlZnQpIG9yIDEgKHJpZ2h0KVxudmVjMiBnZXRFeHRydXNpb25PZmZzZXQodmVjMiBsaW5lX2NsaXBzcGFjZSwgZmxvYXQgb2Zmc2V0X2RpcmVjdGlvbikge1xuICAvLyBub3JtYWxpemVkIGRpcmVjdGlvbiBvZiB0aGUgbGluZVxuICB2ZWMyIGRpcl9zY3JlZW5zcGFjZSA9IG5vcm1hbGl6ZShsaW5lX2NsaXBzcGFjZSAqIHByb2plY3RfdVZpZXdwb3J0U2l6ZSk7XG4gIC8vIHJvdGF0ZSBieSA5MCBkZWdyZWVzXG4gIGRpcl9zY3JlZW5zcGFjZSA9IHZlYzIoLWRpcl9zY3JlZW5zcGFjZS55LCBkaXJfc2NyZWVuc3BhY2UueCk7XG5cbiAgdmVjMiBvZmZzZXRfc2NyZWVuc3BhY2UgPSBkaXJfc2NyZWVuc3BhY2UgKiBvZmZzZXRfZGlyZWN0aW9uICogc3Ryb2tlV2lkdGggLyAyLjA7XG4gIHZlYzIgb2Zmc2V0X2NsaXBzcGFjZSA9IHByb2plY3RfcGl4ZWxfdG9fY2xpcHNwYWNlKG9mZnNldF9zY3JlZW5zcGFjZSkueHk7XG5cbiAgcmV0dXJuIG9mZnNldF9jbGlwc3BhY2U7XG59XG5cbmZsb2F0IGdldFNlZ21lbnRSYXRpbyhmbG9hdCBpbmRleCkge1xuICByZXR1cm4gc21vb3Roc3RlcCgwLjAsIDEuMCwgaW5kZXggLyAobnVtU2VnbWVudHMgLSAxLjApKTtcbn1cblxudmVjMyBnZXRQb3ModmVjMiBzb3VyY2UsIHZlYzIgdGFyZ2V0LCBmbG9hdCBzZWdtZW50UmF0aW8pIHtcbiAgZmxvYXQgdmVydGV4X2hlaWdodCA9IHBhcmFib2xvaWQoc291cmNlLCB0YXJnZXQsIHNlZ21lbnRSYXRpbyk7XG5cbiAgcmV0dXJuIHZlYzMoXG4gICAgbWl4KHNvdXJjZSwgdGFyZ2V0LCBzZWdtZW50UmF0aW8pLFxuICAgIHNxcnQobWF4KDAuMCwgdmVydGV4X2hlaWdodCkpXG4gICk7XG59XG5cbnZvaWQgbWFpbih2b2lkKSB7XG4gIHZlYzIgc291cmNlID0gcHJvamVjdF9wb3NpdGlvbihpbnN0YW5jZVBvc2l0aW9ucy54eSk7XG4gIHZlYzIgdGFyZ2V0ID0gcHJvamVjdF9wb3NpdGlvbihpbnN0YW5jZVBvc2l0aW9ucy56dyk7XG5cbiAgZmxvYXQgc2VnbWVudEluZGV4ID0gcG9zaXRpb25zLng7XG4gIGZsb2F0IHNlZ21lbnRSYXRpbyA9IGdldFNlZ21lbnRSYXRpbyhzZWdtZW50SW5kZXgpO1xuICAvLyBpZiBpdCdzIHRoZSBmaXJzdCBwb2ludCwgdXNlIG5leHQgLSBjdXJyZW50IGFzIGRpcmVjdGlvblxuICAvLyBvdGhlcndpc2UgdXNlIGN1cnJlbnQgLSBwcmV2XG4gIGZsb2F0IGluZGV4RGlyID0gbWl4KC0xLjAsIDEuMCwgc3RlcChzZWdtZW50SW5kZXgsIDAuMCkpO1xuICBmbG9hdCBuZXh0U2VnbWVudFJhdGlvID0gZ2V0U2VnbWVudFJhdGlvKHNlZ21lbnRJbmRleCArIGluZGV4RGlyKTtcblxuICB2ZWMzIGN1cnJQb3MgPSBnZXRQb3Moc291cmNlLCB0YXJnZXQsIHNlZ21lbnRSYXRpbyk7XG4gIHZlYzMgbmV4dFBvcyA9IGdldFBvcyhzb3VyY2UsIHRhcmdldCwgbmV4dFNlZ21lbnRSYXRpbyk7XG4gIHZlYzQgY3VyciA9IHByb2plY3RfdG9fY2xpcHNwYWNlKHZlYzQoY3VyclBvcywgMS4wKSk7XG4gIHZlYzQgbmV4dCA9IHByb2plY3RfdG9fY2xpcHNwYWNlKHZlYzQobmV4dFBvcywgMS4wKSk7XG5cbiAgLy8gZXh0cnVkZVxuICB2ZWMyIG9mZnNldCA9IGdldEV4dHJ1c2lvbk9mZnNldCgobmV4dC54eSAtIGN1cnIueHkpICogaW5kZXhEaXIsIHBvc2l0aW9ucy55KTtcbiAgZ2xfUG9zaXRpb24gPSBjdXJyICsgdmVjNChvZmZzZXQsIDAuMCwgMC4wKTtcblxuICB2ZWM0IGNvbG9yID0gbWl4KGluc3RhbmNlU291cmNlQ29sb3JzLCBpbnN0YW5jZVRhcmdldENvbG9ycywgc2VnbWVudFJhdGlvKSAvIDI1NS47XG4gIHZDb2xvciA9IHZlYzQoY29sb3IucmdiLCBjb2xvci5hICogb3BhY2l0eSk7XG5cbiAgLy8gU2V0IGNvbG9yIHRvIGJlIHJlbmRlcmVkIHRvIHBpY2tpbmcgZmJvIChhbHNvIHVzZWQgdG8gY2hlY2sgZm9yIHNlbGVjdGlvbiBoaWdobGlnaHQpLlxuICBwaWNraW5nX3NldFBpY2tpbmdDb2xvcihpbnN0YW5jZVBpY2tpbmdDb2xvcnMpO1xufVxuYDtcbiJdfQ==