'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _core = require('../../core');

var _scatterplotLayer = require('../scatterplot-layer/scatterplot-layer');

var _scatterplotLayer2 = _interopRequireDefault(_scatterplotLayer);

var _pathLayer = require('../path-layer/path-layer');

var _pathLayer2 = _interopRequireDefault(_pathLayer);

var _solidPolygonLayer = require('../solid-polygon-layer/solid-polygon-layer');

var _solidPolygonLayer2 = _interopRequireDefault(_solidPolygonLayer);

var _geojson = require('./geojson');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } // Copyright (c) 2015 - 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

var get = _core.experimental.get;
// Use primitive layer to avoid "Composite Composite" layers for now

var defaultLineColor = [0x0, 0x0, 0x0, 0xff];
var defaultFillColor = [0x0, 0x0, 0x0, 0xff];

var defaultProps = {
  stroked: true,
  filled: true,
  extruded: false,
  wireframe: false,

  lineWidthScale: 1,
  lineWidthMinPixels: 0,
  lineWidthMaxPixels: Number.MAX_SAFE_INTEGER,
  lineJointRounded: false,
  lineMiterLimit: 4,

  elevationScale: 1,

  pointRadiusScale: 1,
  pointRadiusMinPixels: 0, //  min point radius in pixels
  pointRadiusMaxPixels: Number.MAX_SAFE_INTEGER, // max point radius in pixels

  fp64: false,

  // Line and polygon outline color
  getLineColor: function getLineColor(f) {
    return get(f, 'properties.lineColor') || defaultLineColor;
  },
  // Point and polygon fill color
  getFillColor: function getFillColor(f) {
    return get(f, 'properties.fillColor') || defaultFillColor;
  },
  // Point radius
  getRadius: function getRadius(f) {
    return get(f, 'properties.radius') || get(f, 'properties.size') || 1;
  },
  // Line and polygon outline accessors
  getLineWidth: function getLineWidth(f) {
    return get(f, 'properties.lineWidth') || 1;
  },
  // Polygon extrusion accessor
  getElevation: function getElevation(f) {
    return get(f, 'properties.elevation') || 1000;
  },

  subLayers: {
    PointLayer: _scatterplotLayer2.default,
    LineLayer: _pathLayer2.default,
    PolygonLayer: _solidPolygonLayer2.default
  },

  // Optional settings for 'lighting' shader module
  lightSettings: {
    lightsPosition: [-122.45, 37.75, 8000, -122.0, 38.0, 5000],
    ambientRatio: 0.05,
    diffuseRatio: 0.6,
    specularRatio: 0.8,
    lightsStrength: [2.0, 0.0, 0.0, 0.0],
    numberOfLights: 2
  }
};

var getCoordinates = function getCoordinates(f) {
  return f.geometry.coordinates;
};

var GeoJsonLayer = function (_CompositeLayer) {
  _inherits(GeoJsonLayer, _CompositeLayer);

  function GeoJsonLayer() {
    _classCallCheck(this, GeoJsonLayer);

    return _possibleConstructorReturn(this, (GeoJsonLayer.__proto__ || Object.getPrototypeOf(GeoJsonLayer)).apply(this, arguments));
  }

  _createClass(GeoJsonLayer, [{
    key: 'initializeState',
    value: function initializeState() {
      this.state = {
        features: {}
      };
    }
  }, {
    key: 'updateState',
    value: function updateState(_ref) {
      var oldProps = _ref.oldProps,
          props = _ref.props,
          changeFlags = _ref.changeFlags;

      if (changeFlags.dataChanged) {
        var data = this.props.data;

        var features = (0, _geojson.getGeojsonFeatures)(data);
        this.state.features = (0, _geojson.separateGeojsonFeatures)(features);
      }
    }
  }, {
    key: 'getPickingInfo',
    value: function getPickingInfo(_ref2) {
      var info = _ref2.info;

      return Object.assign(info, {
        // override object with picked feature
        object: info.object && info.object.feature || info.object
      });
    }

    /* eslint-disable complexity */

  }, {
    key: 'renderLayers',
    value: function renderLayers() {
      var features = this.state.features;
      var pointFeatures = features.pointFeatures,
          lineFeatures = features.lineFeatures,
          polygonFeatures = features.polygonFeatures,
          polygonOutlineFeatures = features.polygonOutlineFeatures;

      // Layer composition props

      var _props = this.props,
          stroked = _props.stroked,
          filled = _props.filled,
          extruded = _props.extruded,
          wireframe = _props.wireframe,
          subLayers = _props.subLayers,
          lightSettings = _props.lightSettings;

      // Rendering props underlying layer

      var _props2 = this.props,
          lineWidthScale = _props2.lineWidthScale,
          lineWidthMinPixels = _props2.lineWidthMinPixels,
          lineWidthMaxPixels = _props2.lineWidthMaxPixels,
          lineJointRounded = _props2.lineJointRounded,
          lineMiterLimit = _props2.lineMiterLimit,
          pointRadiusScale = _props2.pointRadiusScale,
          pointRadiusMinPixels = _props2.pointRadiusMinPixels,
          pointRadiusMaxPixels = _props2.pointRadiusMaxPixels,
          elevationScale = _props2.elevationScale,
          fp64 = _props2.fp64;

      // Accessor props for underlying layers

      var _props3 = this.props,
          getLineColor = _props3.getLineColor,
          getFillColor = _props3.getFillColor,
          getRadius = _props3.getRadius,
          getLineWidth = _props3.getLineWidth,
          getElevation = _props3.getElevation,
          updateTriggers = _props3.updateTriggers;


      var drawPoints = pointFeatures && pointFeatures.length > 0;
      var drawLines = lineFeatures && lineFeatures.length > 0;
      var hasPolygonLines = polygonOutlineFeatures && polygonOutlineFeatures.length > 0;
      var hasPolygon = polygonFeatures && polygonFeatures.length > 0;

      // Filled Polygon Layer
      var polygonFillLayer = filled && hasPolygon && new subLayers.PolygonLayer(this.getSubLayerProps({
        id: 'polygon-fill',
        updateTriggers: {
          getElevation: updateTriggers.getElevation,
          getColor: updateTriggers.getFillColor
        }
      }), {
        data: polygonFeatures,
        fp64: fp64,
        extruded: extruded,
        elevationScale: elevationScale,
        wireframe: false,
        lightSettings: lightSettings,
        getPolygon: getCoordinates,
        getElevation: getElevation,
        getColor: getFillColor
      });

      var polygonWireframeLayer = wireframe && extruded && hasPolygon && new subLayers.PolygonLayer(this.getSubLayerProps({
        id: 'polygon-wireframe',
        updateTriggers: {
          getElevation: updateTriggers.getElevation,
          getColor: updateTriggers.getLineColor
        }
      }), {
        data: polygonFeatures,

        fp64: fp64,
        extruded: extruded,
        elevationScale: elevationScale,
        wireframe: true,
        getPolygon: getCoordinates,
        getElevation: getElevation,
        getColor: getLineColor
      });

      var polygonLineLayer = !extruded && stroked && hasPolygonLines && new subLayers.LineLayer(this.getSubLayerProps({
        id: 'polygon-outline',
        updateTriggers: {
          getColor: updateTriggers.getLineColor,
          getWidth: updateTriggers.getLineWidth
        }
      }), {
        data: polygonOutlineFeatures,

        fp64: fp64,
        widthScale: lineWidthScale,
        widthMinPixels: lineWidthMinPixels,
        widthMaxPixels: lineWidthMaxPixels,
        rounded: lineJointRounded,
        miterLimit: lineMiterLimit,

        getPath: getCoordinates,
        getColor: getLineColor,
        getWidth: getLineWidth
      });

      var pathLayer = drawLines && new subLayers.LineLayer(this.getSubLayerProps({
        id: 'line-paths',
        updateTriggers: {
          getColor: updateTriggers.getLineColor,
          getWidth: updateTriggers.getLineWidth
        }
      }), {
        data: lineFeatures,

        fp64: fp64,
        widthScale: lineWidthScale,
        widthMinPixels: lineWidthMinPixels,
        widthMaxPixels: lineWidthMaxPixels,
        rounded: lineJointRounded,
        miterLimit: lineMiterLimit,

        getPath: getCoordinates,
        getColor: getLineColor,
        getWidth: getLineWidth
      });

      var pointLayer = drawPoints && new subLayers.PointLayer(this.getSubLayerProps({
        id: 'points',
        updateTriggers: {
          getColor: updateTriggers.getFillColor,
          getRadius: updateTriggers.getRadius
        }
      }), {
        data: pointFeatures,

        fp64: fp64,
        radiusScale: pointRadiusScale,
        radiusMinPixels: pointRadiusMinPixels,
        radiusMaxPixels: pointRadiusMaxPixels,

        getPosition: getCoordinates,
        getColor: getFillColor,
        getRadius: getRadius
      });

      return [
      // If not extruded: flat fill layer is drawn below outlines
      !extruded && polygonFillLayer, polygonWireframeLayer, polygonLineLayer, pathLayer, pointLayer,
      // If extruded: draw fill layer last for correct blending behavior
      extruded && polygonFillLayer];
    }
    /* eslint-enable complexity */

  }]);

  return GeoJsonLayer;
}(_core.CompositeLayer);

exports.default = GeoJsonLayer;


GeoJsonLayer.layerName = 'GeoJsonLayer';
GeoJsonLayer.defaultProps = defaultProps;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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