"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
// Copyright (c) 2015 - 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

exports.default = "\n#define SHADER_NAME hexagon-cell-layer-vertex-shader\n\nattribute vec3 positions;\nattribute vec3 normals;\n\nattribute vec3 instancePositions;\nattribute vec4 instanceColors;\nattribute vec3 instancePickingColors;\n\n// Custom uniforms\nuniform float opacity;\nuniform float radius;\nuniform float angle;\nuniform float extruded;\nuniform float coverage;\nuniform float elevationScale;\n\n// Result\nvarying vec4 vColor;\n\n// A magic number to scale elevation so that 1 unit approximate to 1 meter.\n#define ELEVATION_SCALE 0.8\n\nvoid main(void) {\n\n  // rotate primitive position and normal\n  mat2 rotationMatrix = mat2(cos(angle), -sin(angle), sin(angle), cos(angle));\n\n  vec2 rPos = rotationMatrix * positions.xz;\n  vec2 rNorm = rotationMatrix * normals.xz; // the hexagon cells has y axis as the vertical axis\n\n  vec3 rotatedPositions = vec3(rPos.x, positions.y, rPos.y);\n  vec3 rotatedNormals = vec3(rNorm.x, rNorm.y, normals.y);\n\n  // calculate elevation, if 3d not enabled set to 0\n  // cylindar gemoetry height are between -0.5 to 0.5, transform it to between 0, 1\n  float elevation = 0.0;\n\n  if (extruded > 0.5) {\n    elevation = project_scale(instancePositions.z * (positions.y + 0.5) *\n      ELEVATION_SCALE * elevationScale);\n  }\n\n  // if ahpha == 0.0 or z < 0.0, do not render element\n  float noRender = float(instanceColors.a == 0.0 || instancePositions.z < 0.0);\n  float dotRadius = radius * mix(coverage, 0.0, noRender);\n\n  // project center of hexagon\n  vec4 centroidPosition = vec4(project_position(instancePositions.xy), elevation, 0.0);\n\n  vec4 position_worldspace = centroidPosition + vec4(vec2(rotatedPositions.xz * dotRadius), 0., 1.);\n\n  gl_Position = project_to_clipspace(position_worldspace);\n\n  // Light calculations\n  // Worldspace is the linear space after Mercator projection\n\n  vec3 normals_worldspace = rotatedNormals;\n\n  float lightWeight = 1.0;\n\n  if (extruded > 0.5) {\n    lightWeight = getLightWeight(\n      position_worldspace.xyz, // the w component is always 1.0\n      normals_worldspace\n    );\n  }\n\n  vec3 lightWeightedColor = lightWeight * instanceColors.rgb;\n\n  // opacity-multiplied instance color\n  vColor = vec4(lightWeightedColor, opacity * instanceColors.a) / 255.0;\n\n  // Set color to be rendered to picking fbo (also used to check for selection highlight).\n  picking_setPickingColor(instancePickingColors);\n}\n";
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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