"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
// Copyright (c) 2015 - 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

exports.default = "#define SHADER_NAME line-layer-vertex-shader-64\n\nattribute vec3 positions;\nattribute vec3 instanceSourcePositions;\nattribute vec3 instanceTargetPositions;\nattribute vec4 instanceSourceTargetPositions64xyLow;\nattribute vec4 instanceColors;\nattribute vec3 instancePickingColors;\n\nuniform float strokeWidth;\nuniform float opacity;\n\nvarying vec4 vColor;\n\n// offset vector by strokeWidth pixels\n// offset_direction is -1 (left) or 1 (right)\nvec2 getExtrusionOffset(vec2 line_clipspace, float offset_direction) {\n  // normalized direction of the line\n  vec2 dir_screenspace = normalize(line_clipspace * project_uViewportSize);\n  // rotate by 90 degrees\n  dir_screenspace = vec2(-dir_screenspace.y, dir_screenspace.x);\n\n  vec2 offset_screenspace = dir_screenspace * offset_direction * strokeWidth / 2.0;\n  vec2 offset_clipspace = project_pixel_to_clipspace(offset_screenspace).xy;\n\n  return offset_clipspace;\n}\n\nvoid main(void) {\n  // Position\n  vec4 instanceSourcePositions64 = vec4(\n    instanceSourcePositions.x, instanceSourceTargetPositions64xyLow.x,\n    instanceSourcePositions.y, instanceSourceTargetPositions64xyLow.y);\n\n  vec4 instanceTargetPositions64 = vec4(\n    instanceTargetPositions.x, instanceSourceTargetPositions64xyLow.z,\n    instanceTargetPositions.y, instanceSourceTargetPositions64xyLow.w);\n\n  vec2 projected_source_coord[2];\n  vec2 projected_target_coord[2];\n\n  project_position_fp64(instanceSourcePositions64, projected_source_coord);\n  project_position_fp64(instanceTargetPositions64, projected_target_coord);\n\n  vec2 source_pos_modelspace[4];\n  source_pos_modelspace[0] =  projected_source_coord[0];\n  source_pos_modelspace[1] =  projected_source_coord[1];\n  source_pos_modelspace[2] = vec2(project_scale(instanceSourcePositions.z), 0.0);\n  source_pos_modelspace[3] = vec2(1.0, 0.0);\n\n  vec4 source_pos_clipspace = project_to_clipspace_fp64(source_pos_modelspace);\n\n  vec2 target_pos_modelspace[4];\n  target_pos_modelspace[0] =  projected_target_coord[0];\n  target_pos_modelspace[1] =  projected_target_coord[1];\n  target_pos_modelspace[2] = vec2(project_scale(instanceTargetPositions.z), 0.0);\n  target_pos_modelspace[3] = vec2(1.0, 0.0);\n\n  vec4 target_pos_clipspace = project_to_clipspace_fp64(target_pos_modelspace);\n\n  float segmentIndex = positions.x;\n  vec4 p = mix(source_pos_clipspace, target_pos_clipspace, segmentIndex);\n\n  vec2 offset = getExtrusionOffset(target_pos_clipspace.xy - source_pos_clipspace.xy, positions.y);\n\n  gl_Position = p + vec4(offset, 0.0, 0.0);\n\n  // Color\n  vColor = vec4(instanceColors.rgb, instanceColors.a * opacity) / 255.;\n\n  // Set color to be rendered to picking fbo (also used to check for selection highlight).\n  picking_setPickingColor(instancePickingColors);\n}\n";
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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