"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
// Copyright (c) 2015 - 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

exports.default = "#define SHADER_NAME line-layer-vertex-shader\n\nattribute vec3 positions;\nattribute vec3 instanceSourcePositions;\nattribute vec3 instanceTargetPositions;\nattribute vec4 instanceColors;\nattribute vec3 instancePickingColors;\n\nuniform float strokeWidth;\nuniform float opacity;\n\nvarying vec4 vColor;\n\n// offset vector by strokeWidth pixels\n// offset_direction is -1 (left) or 1 (right)\nvec2 getExtrusionOffset(vec2 line_clipspace, float offset_direction) {\n  // normalized direction of the line\n  vec2 dir_screenspace = normalize(line_clipspace * project_uViewportSize);\n  // rotate by 90 degrees\n  dir_screenspace = vec2(-dir_screenspace.y, dir_screenspace.x);\n\n  vec2 offset_screenspace = dir_screenspace * offset_direction * strokeWidth / 2.0;\n  vec2 offset_clipspace = project_pixel_to_clipspace(offset_screenspace).xy;\n\n  return offset_clipspace;\n}\n\nvoid main(void) {\n  // Position\n  vec3 sourcePos = project_position(instanceSourcePositions);\n  vec3 targetPos = project_position(instanceTargetPositions);\n  vec4 source = project_to_clipspace(vec4(sourcePos, 1.0));\n  vec4 target = project_to_clipspace(vec4(targetPos, 1.0));\n\n  // linear interpolation of source & target to pick right coord\n  float segmentIndex = positions.x;\n  vec4 p = mix(source, target, segmentIndex);\n\n  // extrude\n  vec2 offset = getExtrusionOffset(target.xy - source.xy, positions.y);\n  gl_Position = p + vec4(offset, 0.0, 0.0);\n\n  // Color\n  vColor = vec4(instanceColors.rgb, instanceColors.a * opacity) / 255.;\n\n  // Set color to be rendered to picking fbo (also used to check for selection highlight).\n  picking_setPickingColor(instancePickingColors);\n}\n";
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uLy4uL3NyYy9jb3JlLWxheWVycy9saW5lLWxheWVyL2xpbmUtbGF5ZXItdmVydGV4Lmdsc2wuanMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSIsImZpbGUiOiJsaW5lLWxheWVyLXZlcnRleC5nbHNsLmpzIiwic291cmNlc0NvbnRlbnQiOlsiLy8gQ29weXJpZ2h0IChjKSAyMDE1IC0gMjAxNyBVYmVyIFRlY2hub2xvZ2llcywgSW5jLlxuLy9cbi8vIFBlcm1pc3Npb24gaXMgaGVyZWJ5IGdyYW50ZWQsIGZyZWUgb2YgY2hhcmdlLCB0byBhbnkgcGVyc29uIG9idGFpbmluZyBhIGNvcHlcbi8vIG9mIHRoaXMgc29mdHdhcmUgYW5kIGFzc29jaWF0ZWQgZG9jdW1lbnRhdGlvbiBmaWxlcyAodGhlIFwiU29mdHdhcmVcIiksIHRvIGRlYWxcbi8vIGluIHRoZSBTb2Z0d2FyZSB3aXRob3V0IHJlc3RyaWN0aW9uLCBpbmNsdWRpbmcgd2l0aG91dCBsaW1pdGF0aW9uIHRoZSByaWdodHNcbi8vIHRvIHVzZSwgY29weSwgbW9kaWZ5LCBtZXJnZSwgcHVibGlzaCwgZGlzdHJpYnV0ZSwgc3VibGljZW5zZSwgYW5kL29yIHNlbGxcbi8vIGNvcGllcyBvZiB0aGUgU29mdHdhcmUsIGFuZCB0byBwZXJtaXQgcGVyc29ucyB0byB3aG9tIHRoZSBTb2Z0d2FyZSBpc1xuLy8gZnVybmlzaGVkIHRvIGRvIHNvLCBzdWJqZWN0IHRvIHRoZSBmb2xsb3dpbmcgY29uZGl0aW9uczpcbi8vXG4vLyBUaGUgYWJvdmUgY29weXJpZ2h0IG5vdGljZSBhbmQgdGhpcyBwZXJtaXNzaW9uIG5vdGljZSBzaGFsbCBiZSBpbmNsdWRlZCBpblxuLy8gYWxsIGNvcGllcyBvciBzdWJzdGFudGlhbCBwb3J0aW9ucyBvZiB0aGUgU29mdHdhcmUuXG4vL1xuLy8gVEhFIFNPRlRXQVJFIElTIFBST1ZJREVEIFwiQVMgSVNcIiwgV0lUSE9VVCBXQVJSQU5UWSBPRiBBTlkgS0lORCwgRVhQUkVTUyBPUlxuLy8gSU1QTElFRCwgSU5DTFVESU5HIEJVVCBOT1QgTElNSVRFRCBUTyBUSEUgV0FSUkFOVElFUyBPRiBNRVJDSEFOVEFCSUxJVFksXG4vLyBGSVRORVNTIEZPUiBBIFBBUlRJQ1VMQVIgUFVSUE9TRSBBTkQgTk9OSU5GUklOR0VNRU5ULiBJTiBOTyBFVkVOVCBTSEFMTCBUSEVcbi8vIEFVVEhPUlMgT1IgQ09QWVJJR0hUIEhPTERFUlMgQkUgTElBQkxFIEZPUiBBTlkgQ0xBSU0sIERBTUFHRVMgT1IgT1RIRVJcbi8vIExJQUJJTElUWSwgV0hFVEhFUiBJTiBBTiBBQ1RJT04gT0YgQ09OVFJBQ1QsIFRPUlQgT1IgT1RIRVJXSVNFLCBBUklTSU5HIEZST00sXG4vLyBPVVQgT0YgT1IgSU4gQ09OTkVDVElPTiBXSVRIIFRIRSBTT0ZUV0FSRSBPUiBUSEUgVVNFIE9SIE9USEVSIERFQUxJTkdTIElOXG4vLyBUSEUgU09GVFdBUkUuXG5cbmV4cG9ydCBkZWZhdWx0IGBcXFxuI2RlZmluZSBTSEFERVJfTkFNRSBsaW5lLWxheWVyLXZlcnRleC1zaGFkZXJcblxuYXR0cmlidXRlIHZlYzMgcG9zaXRpb25zO1xuYXR0cmlidXRlIHZlYzMgaW5zdGFuY2VTb3VyY2VQb3NpdGlvbnM7XG5hdHRyaWJ1dGUgdmVjMyBpbnN0YW5jZVRhcmdldFBvc2l0aW9ucztcbmF0dHJpYnV0ZSB2ZWM0IGluc3RhbmNlQ29sb3JzO1xuYXR0cmlidXRlIHZlYzMgaW5zdGFuY2VQaWNraW5nQ29sb3JzO1xuXG51bmlmb3JtIGZsb2F0IHN0cm9rZVdpZHRoO1xudW5pZm9ybSBmbG9hdCBvcGFjaXR5O1xuXG52YXJ5aW5nIHZlYzQgdkNvbG9yO1xuXG4vLyBvZmZzZXQgdmVjdG9yIGJ5IHN0cm9rZVdpZHRoIHBpeGVsc1xuLy8gb2Zmc2V0X2RpcmVjdGlvbiBpcyAtMSAobGVmdCkgb3IgMSAocmlnaHQpXG52ZWMyIGdldEV4dHJ1c2lvbk9mZnNldCh2ZWMyIGxpbmVfY2xpcHNwYWNlLCBmbG9hdCBvZmZzZXRfZGlyZWN0aW9uKSB7XG4gIC8vIG5vcm1hbGl6ZWQgZGlyZWN0aW9uIG9mIHRoZSBsaW5lXG4gIHZlYzIgZGlyX3NjcmVlbnNwYWNlID0gbm9ybWFsaXplKGxpbmVfY2xpcHNwYWNlICogcHJvamVjdF91Vmlld3BvcnRTaXplKTtcbiAgLy8gcm90YXRlIGJ5IDkwIGRlZ3JlZXNcbiAgZGlyX3NjcmVlbnNwYWNlID0gdmVjMigtZGlyX3NjcmVlbnNwYWNlLnksIGRpcl9zY3JlZW5zcGFjZS54KTtcblxuICB2ZWMyIG9mZnNldF9zY3JlZW5zcGFjZSA9IGRpcl9zY3JlZW5zcGFjZSAqIG9mZnNldF9kaXJlY3Rpb24gKiBzdHJva2VXaWR0aCAvIDIuMDtcbiAgdmVjMiBvZmZzZXRfY2xpcHNwYWNlID0gcHJvamVjdF9waXhlbF90b19jbGlwc3BhY2Uob2Zmc2V0X3NjcmVlbnNwYWNlKS54eTtcblxuICByZXR1cm4gb2Zmc2V0X2NsaXBzcGFjZTtcbn1cblxudm9pZCBtYWluKHZvaWQpIHtcbiAgLy8gUG9zaXRpb25cbiAgdmVjMyBzb3VyY2VQb3MgPSBwcm9qZWN0X3Bvc2l0aW9uKGluc3RhbmNlU291cmNlUG9zaXRpb25zKTtcbiAgdmVjMyB0YXJnZXRQb3MgPSBwcm9qZWN0X3Bvc2l0aW9uKGluc3RhbmNlVGFyZ2V0UG9zaXRpb25zKTtcbiAgdmVjNCBzb3VyY2UgPSBwcm9qZWN0X3RvX2NsaXBzcGFjZSh2ZWM0KHNvdXJjZVBvcywgMS4wKSk7XG4gIHZlYzQgdGFyZ2V0ID0gcHJvamVjdF90b19jbGlwc3BhY2UodmVjNCh0YXJnZXRQb3MsIDEuMCkpO1xuXG4gIC8vIGxpbmVhciBpbnRlcnBvbGF0aW9uIG9mIHNvdXJjZSAmIHRhcmdldCB0byBwaWNrIHJpZ2h0IGNvb3JkXG4gIGZsb2F0IHNlZ21lbnRJbmRleCA9IHBvc2l0aW9ucy54O1xuICB2ZWM0IHAgPSBtaXgoc291cmNlLCB0YXJnZXQsIHNlZ21lbnRJbmRleCk7XG5cbiAgLy8gZXh0cnVkZVxuICB2ZWMyIG9mZnNldCA9IGdldEV4dHJ1c2lvbk9mZnNldCh0YXJnZXQueHkgLSBzb3VyY2UueHksIHBvc2l0aW9ucy55KTtcbiAgZ2xfUG9zaXRpb24gPSBwICsgdmVjNChvZmZzZXQsIDAuMCwgMC4wKTtcblxuICAvLyBDb2xvclxuICB2Q29sb3IgPSB2ZWM0KGluc3RhbmNlQ29sb3JzLnJnYiwgaW5zdGFuY2VDb2xvcnMuYSAqIG9wYWNpdHkpIC8gMjU1LjtcblxuICAvLyBTZXQgY29sb3IgdG8gYmUgcmVuZGVyZWQgdG8gcGlja2luZyBmYm8gKGFsc28gdXNlZCB0byBjaGVjayBmb3Igc2VsZWN0aW9uIGhpZ2hsaWdodCkuXG4gIHBpY2tpbmdfc2V0UGlja2luZ0NvbG9yKGluc3RhbmNlUGlja2luZ0NvbG9ycyk7XG59XG5gO1xuIl19