"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
// Copyright (c) 2015 - 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

exports.default = "#define SHADER_NAME scatterplot-layer-vertex-shader\n\nattribute vec3 positions;\n\nattribute vec3 instancePositions;\nattribute float instanceRadius;\nattribute vec4 instanceColors;\nattribute vec3 instancePickingColors;\n\nuniform float opacity;\nuniform float radiusScale;\nuniform float radiusMinPixels;\nuniform float radiusMaxPixels;\nuniform float outline;\nuniform float strokeWidth;\n\nvarying vec4 vColor;\nvarying vec2 unitPosition;\nvarying float innerUnitRadius;\n\nvoid main(void) {\n  // Multiply out radius and clamp to limits\n  float outerRadiusPixels = clamp(\n    project_scale(radiusScale * instanceRadius),\n    radiusMinPixels, radiusMaxPixels\n  );\n  // outline is centered at the radius\n  // outer radius needs to offset by half stroke width\n  outerRadiusPixels += outline * strokeWidth / 2.0;\n\n  // position on the containing square in [-1, 1] space\n  unitPosition = positions.xy;\n  // 0 - solid circle, 1 - stroke with lineWidth=0\n  innerUnitRadius = outline * (1.0 - strokeWidth / outerRadiusPixels);\n\n  // Find the center of the point and add the current vertex\n  vec3 center = project_position(instancePositions);\n  vec3 vertex = positions * outerRadiusPixels;\n  gl_Position = project_to_clipspace(vec4(center + vertex, 1.0));\n\n  // Apply opacity to instance color, or return instance picking color\n  vColor = vec4(instanceColors.rgb, instanceColors.a * opacity) / 255.;\n\n  // Set color to be rendered to picking fbo (also used to check for selection highlight).\n  picking_setPickingColor(instancePickingColors);\n}\n";
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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