"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.compareArrays = compareArrays;
exports.checkArray = checkArray;
// Copyright (c) 2015 - 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
function compareArrays(array1, array2) {
  var length = Math.min(array1.length, array2.length);
  for (var i = 0; i < length; ++i) {
    if (array1[i] !== array2[i]) {
      return "Arrays are different in element " + i + ": " + array1[i] + " vs " + array2[i];
    }
  }

  if (array1.length !== array2.length) {
    return "Arrays have different length " + array1.length + " vs " + array2.length;
  }

  return null;
}

function checkArray(array) {
  for (var i = 0; i < array.length; ++i) {
    if (!Number.isFinite(array[i])) {
      throw new Error("Array has invalid element " + i + ": " + array[i]);
    }
  }
  return null;
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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