"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
// Copyright (c) 2015 - 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// lighting

exports.default = "#define NUM_OF_LIGHTS 2\n\n// TODO these should be using lighting_ prefix\nuniform vec3 lightsPosition[16];\nuniform vec2 lightsStrength[16];\nuniform float ambientRatio;\nuniform float diffuseRatio;\nuniform float specularRatio;\n\nfloat lighting_getLightWeight(vec3 position_worldspace_vec3, vec3 normals_worldspace) {\n  float lightWeight = 0.0;\n\n  vec3 normals_worldspace_vec3 = normals_worldspace.xyz;\n\n  vec3 camera_pos_worldspace = project_uCameraPosition;\n  vec3 view_direction = normalize(camera_pos_worldspace - position_worldspace_vec3);\n\n  for (int i = 0; i < NUM_OF_LIGHTS; i++) {\n    vec3 light_position_worldspace = project_position(lightsPosition[i]);\n    vec3 light_direction = normalize(light_position_worldspace - position_worldspace_vec3);\n\n    vec3 halfway_direction = normalize(light_direction + view_direction);\n    float lambertian = dot(light_direction, normals_worldspace_vec3);\n    float specular = 0.0;\n    if (lambertian > 0.0) {\n      float specular_angle = max(dot(normals_worldspace_vec3, halfway_direction), 0.0);\n      specular = pow(specular_angle, 32.0);\n    }\n    lambertian = max(lambertian, 0.0);\n    lightWeight += (ambientRatio + lambertian * diffuseRatio + specular * specularRatio) *\n      lightsStrength[i].x;\n\n  }\n\n  return lightWeight;\n}\n\n// DEPRECATED - Backwards compatibility\n\nfloat getLightWeight(vec3 position_worldspace_vec3, vec3 normals_worldspace) {\n  return lighting_getLightWeight(position_worldspace_vec3, normals_worldspace);\n}\n";
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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