"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
// Copyright (c) 2015 - 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

exports.default = "\nconst vec2 WORLD_SCALE_FP64 = vec2(81.4873275756836, 0.0000032873668232014097);\n\nuniform vec2 project64_uScale;\nuniform vec2 project_uViewProjectionMatrixFP64[16];\n\n// longitude: lnglat_fp64.xy; latitude: lnglat_fp64.zw\nvoid mercatorProject_fp64(vec4 lnglat_fp64, out vec2 out_val[2]) {\n\n#if defined(NVIDIA_FP64_WORKAROUND)\n  out_val[0] = sum_fp64(radians_fp64(lnglat_fp64.xy), PI_FP64 * ONE);\n#else\n  out_val[0] = sum_fp64(radians_fp64(lnglat_fp64.xy), PI_FP64);\n#endif\n  out_val[1] = sub_fp64(PI_FP64,\n    log_fp64(tan_fp64(sum_fp64(PI_4_FP64, radians_fp64(lnglat_fp64.zw) / 2.0))));\n  return;\n}\n\nvoid project_position_fp64(vec4 position_fp64, out vec2 out_val[2]) {\n  vec2 pos_fp64[2];\n  mercatorProject_fp64(position_fp64, pos_fp64);\n  vec2 x_fp64 = mul_fp64(pos_fp64[0], project64_uScale);\n  vec2 y_fp64 = mul_fp64(pos_fp64[1], project64_uScale);\n  out_val[0] = mul_fp64(x_fp64, WORLD_SCALE_FP64);\n  out_val[1] = mul_fp64(y_fp64, WORLD_SCALE_FP64);\n\n  return;\n}\n\nvec4 project_to_clipspace_fp64(vec2 vertex_pos_modelspace[4]) {\n  vec2 vertex_pos_clipspace[4];\n  mat4_vec4_mul_fp64(project_uViewProjectionMatrixFP64, vertex_pos_modelspace,\n    vertex_pos_clipspace);\n  return vec4(\n    vertex_pos_clipspace[0].x,\n    vertex_pos_clipspace[1].x,\n    vertex_pos_clipspace[2].x,\n    vertex_pos_clipspace[3].x\n    );\n}\n";
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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