"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
// Copyright (c) 2015 - 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

exports.default = "#define SHADER_NAME reflection-effect-fs\n\n#ifdef GL_ES\nprecision highp float;\n#endif\n\nuniform sampler2D reflectionTexture;\nuniform int reflectionTextureWidth;\nuniform int reflectionTextureHeight;\n\nuniform float reflectivity;\nuniform float blur;\n\n\nvarying vec2 uv;\n\n#define KERNEL_SIZE 7\n\n/*\n * Samples from tex with a gaussian-shaped patch, centered at uv and\n * with standard deviation sigma.  The size of the texture in\n * pixels must be specified by dim\n */\nvec4 sample_gaussian(sampler2D tex, vec2 dim, vec2 uv, float sigma) {\n  if (sigma == 0.0) {\n    return texture2D(tex, uv);\n  }\n\n  vec2 delta = 1.0 / dim;\n  vec2 top_left = uv - delta * float(KERNEL_SIZE+1) / 2.0;\n\n  vec4 color = vec4(0);\n  float sum = 0.0;\n  for (int i = 0; i <  KERNEL_SIZE; ++i) {\n    for (int j = 0; j < KERNEL_SIZE; ++j) {\n      vec2 uv2 = top_left + vec2(i, j) * delta;\n      float d = length((uv2 - uv) * dim);\n      float f = exp(-(d*d) / (2.0*sigma * sigma));\n      color += f * texture2D(tex, uv2);\n      sum += f;\n    }\n  }\n  return color / sum;\n}\n\nvoid main(void) {\n  //map blur in [0, 1] to sigma in [0, inf]\n  //alpha will determine the \"steepness\" of our curve.\n  //this was picked just to make the scale feel \"natural\"\n  //if our image is 1000 pixels wide, a blur of 0.5 should correspond\n  //to a sigma of 1 pixels\n  float alpha = 1000.0;\n  float sigma = blur / (alpha * (1.0 - blur));\n  //let this be our standard deviation in terms of screen-widths.\n  //rewrite this in terms of pixels.\n  sigma *= float(reflectionTextureWidth);\n\n\n  gl_FragColor = sample_gaussian(reflectionTexture, vec2(reflectionTextureWidth,\n    reflectionTextureHeight), vec2(uv.x, 1. - uv.y), sigma);\n  //because our canvas expects alphas to be pre-multiplied, we multiply by whole\n  //color vector by reflectivity, not just the alpha channel\n  gl_FragColor *= reflectivity;\n}\n";
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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