"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
// Copyright (c) 2015 - 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

exports.default = "#define SHADER_NAME bezier-curve-layer-vertex-shader\n\nattribute vec3 positions;\nattribute vec3 instanceSourcePositions;\nattribute vec3 instanceTargetPositions;\nattribute vec3 instanceControlPoints;\nattribute vec4 instanceColors;\nattribute vec3 instancePickingColors;\n\nuniform float numSegments;\nuniform float strokeWidth;\nuniform float opacity;\n\nvarying vec4 vColor;\n\n// offset vector by strokeWidth pixels\n// offset_direction is -1 (left) or 1 (right)\nvec2 getExtrusionOffset(vec2 line_clipspace, float offset_direction) {\n  // normalized direction of the line\n  vec2 dir_screenspace = normalize(line_clipspace * project_uViewportSize);\n  // rotate by 90 degrees\n  dir_screenspace = vec2(-dir_screenspace.y, dir_screenspace.x);\n\n  vec2 offset_screenspace = dir_screenspace * offset_direction * strokeWidth / 2.0;\n  vec2 offset_clipspace = project_pixel_to_clipspace(offset_screenspace).xy;\n\n  return offset_clipspace;\n}\n\nfloat getSegmentRatio(float index) {\n  return smoothstep(0.0, 1.0, index / numSegments);\n}\n\nvec4 computeBezierCurve(vec4 source, vec4 target, vec4 controlPoint, float segmentRatio) {\n  float mt = 1.0 - segmentRatio;\n  float mt2 = pow(mt, 2.0);\n  float t2 = pow(segmentRatio, 2.0);\n\n  // quadratic curve\n  float a = mt2;\n  float b = mt * segmentRatio * 2.0;\n  float c = t2;\n  // TODO: if depth is not needed remove z computaitons.\n  vec4 ret = vec4(\n    a * source.x + b * controlPoint.x + c * target.x,\n    a * source.y + b * controlPoint.y + c * target.y,\n    a * source.z + b * controlPoint.z + c * target.z,\n    1.0\n  );\n  return ret;\n}\n\nvoid main(void) {\n  // Position\n  vec3 sourcePos = project_position(instanceSourcePositions);\n  vec3 targetPos = project_position(instanceTargetPositions);\n  vec3 controlPointPos = project_position(instanceControlPoints);\n  vec4 source = project_to_clipspace(vec4(sourcePos, 1.0));\n  vec4 target = project_to_clipspace(vec4(targetPos, 1.0));\n  vec4 controlPoint = project_to_clipspace(vec4(controlPointPos, 1.0));\n\n  // linear interpolation of source & target to pick right coord\n  float segmentIndex = positions.x;\n  float segmentRatio = getSegmentRatio(segmentIndex);\n  vec4 p = computeBezierCurve(source, target, controlPoint, segmentRatio);\n\n  // next point\n  float indexDir = mix(-1.0, 1.0, step(segmentIndex, 0.0));\n  float nextSegmentRatio = getSegmentRatio(segmentIndex + indexDir);\n  vec4 nextP = computeBezierCurve(source, target, controlPoint, nextSegmentRatio);\n\n  // extrude\n  float direction = float(positions.y);\n  direction = mix(-1.0, 1.0, step(segmentIndex, 0.0)) *  direction;\n  vec2 offset = getExtrusionOffset(nextP.xy - p.xy, direction);\n  gl_Position = p + vec4(offset, 0.0, 0.0);\n\n  // Color\n  vColor = vec4(instanceColors.rgb, instanceColors.a * opacity) / 255.;\n\n  // Set color to be rendered to picking fbo (also used to check for selection highlight).\n  picking_setPickingColor(instancePickingColors);\n}\n";
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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