"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
// Copyright (c) 2015 - 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

exports.default = "#define SHADER_NAME solid-polygon-layer-vertex-shader-64\n\nattribute vec2 vertexPositions;\nattribute vec3 positions;\nattribute vec2 positions64xyLow;\nattribute vec3 nextPositions;\nattribute vec2 nextPositions64xyLow;\nattribute float elevations;\nattribute vec4 colors;\nattribute vec3 pickingColors;\n\nuniform float isSideVertex;\nuniform float extruded;\nuniform float elevationScale;\nuniform float opacity;\n\nvarying vec4 vColor;\n\nvoid main(void) {\n\n  vec3 pos;\n  vec2 pos64xyLow;\n  vec3 normal;\n\n  if (isSideVertex > 0.5) {\n    pos = mix(positions, nextPositions, vertexPositions.x);\n    pos64xyLow = mix(positions64xyLow, nextPositions64xyLow, vertexPositions.x);\n  } else {\n    pos = positions;\n    pos64xyLow = positions64xyLow;\n  }\n  if (extruded > 0.5) {\n    pos.z += elevations * vertexPositions.y;\n  }\n\n  vec4 positions64xy = vec4(pos.x, pos64xyLow.x, pos.y, pos64xyLow.y);\n\n  vec2 projected_coord_xy[2];\n  project_position_fp64(positions64xy, projected_coord_xy);\n\n  vec2 vertex_pos_modelspace[4];\n  vertex_pos_modelspace[0] = projected_coord_xy[0];\n  vertex_pos_modelspace[1] = projected_coord_xy[1];\n  vertex_pos_modelspace[2] = vec2(project_scale(pos.z * elevationScale), 0.0);\n  vertex_pos_modelspace[3] = vec2(1.0, 0.0);\n\n  gl_Position = project_to_clipspace_fp64(vertex_pos_modelspace);\n\n  vec4 position_worldspace = vec4(\n    vertex_pos_modelspace[0].x, vertex_pos_modelspace[1].x,\n    vertex_pos_modelspace[2].x, vertex_pos_modelspace[3].x);\n\n  float lightWeight = 1.0;\n\n  if (extruded > 0.5) {\n    if (isSideVertex > 0.5) {\n      normal = vec3(positions.y - nextPositions.y, nextPositions.x - positions.x, 0.0);\n      normal = project_normal(normal);\n    } else {\n      normal = vec3(0.0, 0.0, 1.0);\n    }\n\n    lightWeight = getLightWeight(position_worldspace.xyz, normal);\n  }\n\n  vec3 lightWeightedColor = lightWeight * colors.rgb;\n  vColor = vec4(lightWeightedColor, colors.a * opacity) / 255.0;\n\n  // Set color to be rendered to picking fbo (also used to check for selection highlight).\n  picking_setPickingColor(pickingColors);\n}\n";
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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