"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
// Copyright (c) 2015 - 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

exports.default = "#define SHADER_NAME solid-polygon-layer-vertex-shader\n\nattribute vec2 vertexPositions;\nattribute vec3 positions;\nattribute vec3 nextPositions;\nattribute float elevations;\nattribute vec4 colors;\nattribute vec3 pickingColors;\n\nuniform float isSideVertex;\nuniform float extruded;\nuniform float elevationScale;\nuniform float opacity;\n\nvarying vec4 vColor;\n\nvoid main(void) {\n\n  vec3 pos;\n  vec3 normal;\n\n  if (isSideVertex > 0.5) {\n    pos = mix(positions, nextPositions, vertexPositions.x);\n  } else {\n    pos = positions;\n  }\n  if (extruded > 0.5) {\n    pos.z += elevations * vertexPositions.y;\n  }\n\n  vec4 position_worldspace = vec4(project_position(\n    vec3(pos.xy, pos.z * elevationScale)),\n    1.0\n  );\n  gl_Position = project_to_clipspace(position_worldspace);\n\n  float lightWeight = 1.0;\n  \n  if (extruded > 0.5) {\n    if (isSideVertex > 0.5) {\n      normal = vec3(positions.y - nextPositions.y, nextPositions.x - positions.x, 0.0);\n      normal = project_normal(normal);\n    } else {\n      normal = vec3(0.0, 0.0, 1.0);\n    }\n\n    // Here, the input parameters should be\n    // position_worldspace.xyz / position_worldspace.w.\n    // However, this calculation generates all zeros on\n    // MacBook Pro with Intel Iris Pro GPUs for unclear reasons.\n    // (see https://github.com/uber/deck.gl/issues/559)\n    // Since the w component is always 1.0 in our shaders,\n    // we decided to just provide xyz component of position_worldspace\n    // to the getLightWeight() function\n    lightWeight = getLightWeight(position_worldspace.xyz, normal);\n  }\n\n  vec3 lightWeightedColor = lightWeight * colors.rgb;\n  vColor = vec4(lightWeightedColor, colors.a * opacity) / 255.0;\n\n  // Set color to be rendered to picking fbo (also used to check for selection highlight).\n  picking_setPickingColor(pickingColors);\n}\n";
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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