'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.makeFontAtlas = makeFontAtlas;

var _luma = require('luma.gl');

var MAX_CANVAS_WIDTH = 1024; /* global document */

var fontSize = 64;
var padding = 2;

var charList = [];
for (var i = 32; i < 128; i++) {
  charList.push(String.fromCharCode(i));
}

function setTextStyle(ctx, fontFamily) {
  ctx.font = fontSize + 'px ' + fontFamily;
  ctx.fillStyle = '#000';
  ctx.textBaseline = 'hanging';
  ctx.textAlign = 'left';
}

function makeFontAtlas(gl, fontFamily) {
  var canvas = document.createElement('canvas');
  var ctx = canvas.getContext('2d');
  setTextStyle(ctx, fontFamily);

  // measure texts
  var row = 0;
  var x = 0;
  var mapping = {};

  charList.forEach(function (char) {
    var _ctx$measureText = ctx.measureText(char),
        width = _ctx$measureText.width;

    if (x + width > MAX_CANVAS_WIDTH) {
      x = 0;
      row++;
    }
    mapping[char] = {
      x: x,
      y: row * (fontSize + padding),
      width: width,
      height: fontSize,
      mask: true
    };
    x += width;
  });

  canvas.width = MAX_CANVAS_WIDTH;
  canvas.height = (row + 1) * (fontSize + padding);

  setTextStyle(ctx, fontFamily);
  for (var char in mapping) {
    ctx.fillText(char, mapping[char].x, mapping[char].y);
  }

  return {
    mapping: mapping,
    texture: new _luma.Texture2D(gl, {
      pixels: canvas
      // no need to specify texture filter here
      // icon layer use the most accurate mode by default
    })
  };
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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