'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.testInitializeLayer = testInitializeLayer;
exports.testUpdateLayer = testUpdateLayer;
exports.testDrawLayer = testDrawLayer;

var _deck = require('deck.gl');

var _setupGl = require('./utils/setup-gl');

var _setupGl2 = _interopRequireDefault(_setupGl);

function _interopRequireDefault(obj) {
  return obj && obj.__esModule ? obj : { default: obj };
}

// Copyright (c) 2015 - 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

function testInitializeLayer(_ref) {
  var layer = _ref.layer,
      viewport = _ref.viewport;

  var layerManager = new _deck.LayerManager(_setupGl2.default);

  try {
    layerManager.setLayers([layer]);
  } catch (error) {
    return error;
  }

  return null;
}

function testUpdateLayer(_ref2) {
  var layer = _ref2.layer,
      viewport = _ref2.viewport,
      newProps = _ref2.newProps;

  var layerManager = new _deck.LayerManager(_setupGl2.default);

  try {
    layerManager.setLayers([layer]);
    layerManager.setLayers([layer.clone(newProps)]);
  } catch (error) {
    return error;
  }

  return null;
}

function testDrawLayer(_ref3) {
  var layer = _ref3.layer,
      _ref3$uniforms = _ref3.uniforms,
      uniforms = _ref3$uniforms === undefined ? {} : _ref3$uniforms;

  var layerManager = new _deck.LayerManager(_setupGl2.default);

  try {
    layerManager.setLayers([layer]);
    layerManager.drawLayers();
  } catch (error) {
    return error;
  }

  return null;
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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