'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.loadFiles = loadFiles;
exports.loadImages = loadImages;

var _assert = require('assert');

var _assert2 = _interopRequireDefault(_assert);

var _browserLoadFile = require('./browser-load-file');

var _browserLoadImage = require('./browser-load-image');

function _interopRequireDefault(obj) {
  return obj && obj.__esModule ? obj : { default: obj };
}

function noop() {}

/*
 * Loads (Requests) multiple files asynchronously
 */
/* eslint-disable guard-for-in, complexity, no-try-catch */
function loadFiles() {
  var opts = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  var urls = opts.urls,
      _opts$onProgress = opts.onProgress,
      onProgress = _opts$onProgress === undefined ? noop : _opts$onProgress;

  (0, _assert2.default)(urls.every(function (url) {
    return typeof url === 'string';
  }), 'loadImages: {urls} must be array of strings');
  var count = 0;
  return Promise.all(urls.map(function (url) {
    var promise = (0, _browserLoadFile.loadFile)(Object.assign({ url: url }, opts));
    promise.then(function (file) {
      return onProgress({
        progress: ++count / urls.length,
        count: count,
        total: urls.length,
        url: url
      });
    });
    return promise;
  }));
}

/*
 * Loads (requests) multiple images asynchronously
 */
function loadImages() {
  var opts = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  var urls = opts.urls,
      _opts$onProgress2 = opts.onProgress,
      onProgress = _opts$onProgress2 === undefined ? noop : _opts$onProgress2;

  (0, _assert2.default)(urls.every(function (url) {
    return typeof url === 'string';
  }), 'loadImages: {urls} must be array of strings');
  var count = 0;
  return Promise.all(urls.map(function (url) {
    var promise = (0, _browserLoadImage.loadImage)(url, opts);
    promise.then(function (file) {
      return onProgress({
        progress: ++count / urls.length,
        count: count,
        total: urls.length,
        url: url
      });
    });
    return promise;
  }));
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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