'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () {
  function defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }return function (Constructor, protoProps, staticProps) {
    if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
  };
}(); // Copyright (c) 2015 - 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

var _global = require('global');

var _assert = require('assert');

var _assert2 = _interopRequireDefault(_assert);

var _sceneRenderer = require('./scene-renderer');

var _sceneRenderer2 = _interopRequireDefault(_sceneRenderer);

var _gpgpu = require('./luma.gl/gpgpu');

var _browserImageUtils = require('./luma.gl/io-basic/browser-image-utils');

function _interopRequireDefault(obj) {
  return obj && obj.__esModule ? obj : { default: obj };
}

function _classCallCheck(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}

var RenderTest = function () {
  function RenderTest() {
    var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
        testCases = _ref.testCases,
        _ref$width = _ref.width,
        width = _ref$width === undefined ? 800 : _ref$width,
        _ref$height = _ref.height,
        height = _ref$height === undefined ? 450 : _ref$height,
        _ref$colorDeltaThresh = _ref.colorDeltaThreshold,
        colorDeltaThreshold = _ref$colorDeltaThresh === undefined ? 255 * 0.05 : _ref$colorDeltaThresh,
        _ref$testPassThreshol = _ref.testPassThreshold,
        testPassThreshold = _ref$testPassThreshol === undefined ? 0.99 : _ref$testPassThreshol,
        _ref$stopOnFail = _ref.stopOnFail,
        stopOnFail = _ref$stopOnFail === undefined ? true : _ref$stopOnFail,
        _ref$reportResult = _ref.reportResult,
        reportResult = _ref$reportResult === undefined ? reportResultInBrowser : _ref$reportResult,
        _ref$reportFinalResul = _ref.reportFinalResult,
        reportFinalResult = _ref$reportFinalResul === undefined ? reportFinalResultInBrowser : _ref$reportFinalResul;

    _classCallCheck(this, RenderTest);

    (0, _assert2.default)(testCases);

    this.sceneRenderer = new _sceneRenderer2.default({
      width: width,
      height: height,
      scenes: testCases,
      onSceneRendered: this._onSceneRendered.bind(this),
      onComplete: this._onComplete.bind(this)
    });

    this.colorDeltaThreshold = colorDeltaThreshold;
    this.testPassThreshold = testPassThreshold;
    this.reportResult = reportResult;
    this.reportFinalResult = reportFinalResult;

    Object.assign(this, initializeDOM({ width: width, height: height }));
  }

  _createClass(RenderTest, [{
    key: 'run',
    value: function run() {
      this.passed = true;
      this.failedTest = null;
      this.sceneRenderer.run();
    }

    // PRIVATE METHODS

  }, {
    key: '_diffResult',
    value: function _diffResult(_ref2) {
      var name = _ref2.name,
          image = _ref2.image,
          referenceImage = _ref2.referenceImage;

      var referencePixelData = (0, _browserImageUtils.getImagePixelData)(referenceImage);
      var resultPixelData = (0, _browserImageUtils.getImagePixelData)(image);

      var percentage = (0, _gpgpu.diffImagePixels)(resultPixelData, referencePixelData);

      var passed = percentage >= this.testPassThreshold;
      this.passed = this.passed && passed;
      this.failedTest = this.failedTest || (this.passed ? null : name);

      return {
        name: name,
        passed: passed,
        percentage: percentage,
        testPassThreshold: this.testPassThreshold
      };
    }
  }, {
    key: '_loadReferenceImage',
    value: function _loadReferenceImage(url) {
      var _this = this;

      return new Promise(function (resolve) {
        _this.referenceImage.onload = function () {
          resolve(_this.referenceImage);
        };

        _this.referenceImage.src = url;
      });
    }
  }, {
    key: '_onSceneRendered',
    value: function _onSceneRendered(_ref3) {
      var _this2 = this;

      var name = _ref3.name,
          image = _ref3.image,
          referenceImageUrl = _ref3.referenceImageUrl;

      return this._loadReferenceImage(referenceImageUrl).then(function (referenceImage) {
        // Both images are loaded, compare results
        var _diffResult2 = _this2._diffResult({
          name: name,
          image: image,
          referenceImage: referenceImage
        }),
            passed = _diffResult2.passed,
            percentage = _diffResult2.percentage,
            testPassThreshold = _diffResult2.testPassThreshold;

        // Print diff result


        _this2.reportResult({
          renderTest: _this2,
          name: name,
          passed: passed,
          percentage: percentage,
          testPassThreshold: testPassThreshold
        });

        if (!passed) {
          _this2.sceneRenderer.stop();
        }
      });
    }
  }, {
    key: '_onComplete',
    value: function _onComplete() {
      this.reportFinalResult({ passed: this.passed, renderTest: this });
      this._reportToTestDriver();
    }

    // Node test driver (puppeteer) may not have had time to expose the function
    // if the test suite is short. If not available, wait a second and try again

  }, {
    key: '_reportToTestDriver',
    value: function _reportToTestDriver() {
      if (_global.window.testDone) {
        var result = { success: this.passed, failedTest: this.failedTest || '' };
        var resultString = JSON.stringify(result);
        _global.window.testDone(resultString);
      } else {
        console.warn('testDone not exposed, waiting 1 second'); // eslint-disable-line
        _global.window.setTimeout(this._reportToTestDriver.bind(this), 1000);
      }
    }
  }]);

  return RenderTest;
}();

exports.default = RenderTest;

function initializeDOM(_ref4) {
  var width = _ref4.width,
      height = _ref4.height;

  // DeckGL container
  var deckGLContainer = _global.document.createElement('div');
  deckGLContainer.style.position = 'absolute';
  // hide deckgl canvas
  deckGLContainer.style.visibility = 'hidden';

  var referenceImage = (0, _browserImageUtils.createImage)(width, height);

  var resultContainer = _global.document.createElement('div');
  resultContainer.style.position = 'absolute';
  resultContainer.style.top = '0px';
  resultContainer.style.left = width + 'px';
  resultContainer.style.zIndex = 1;

  // Final flag container
  var flagContainer = _global.document.createElement('div');
  flagContainer.style.position = 'absolute';
  flagContainer.style.top = height + 50 + 'px';

  _global.document.body.appendChild(deckGLContainer);
  _global.document.body.appendChild(referenceImage);
  // document.body.appendChild(resultImage);
  _global.document.body.appendChild(resultContainer);
  _global.document.body.appendChild(flagContainer);

  return { resultContainer: resultContainer, flagContainer: flagContainer, referenceImage: referenceImage };
}

// Default reporting method
function reportResultInBrowser(_ref5) {
  var name = _ref5.name,
      passed = _ref5.passed,
      percentage = _ref5.percentage,
      renderTest = _ref5.renderTest;

  console.log('Rendered new scene ' + name + ' ' + passed); // eslint-disable-line

  var outputString = name + ': ' + (percentage * 100).toFixed(3) + '% ' + (passed ? 'PASS' : 'FAIL');

  var paragraph = _global.document.createElement('p');
  var testResult = _global.document.createTextNode(outputString);
  paragraph.style.color = passed ? '#74ff69' : '#ff2857';
  paragraph.appendChild(testResult);
  renderTest.resultContainer.appendChild(paragraph);
}

function reportFinalResultInBrowser(_ref6) {
  var passed = _ref6.passed,
      renderTest = _ref6.renderTest;

  var outputString = '' + (passed ? 'All CASES PASSED!' : 'NOT All CASES PASSED!');

  var paragraph = _global.document.createElement('p');
  var testResult = _global.document.createTextNode(outputString);
  paragraph.style.color = passed ? '#0bff1c' : '#ff0921';
  paragraph.appendChild(testResult);
  renderTest.flagContainer.appendChild(paragraph);
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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