'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isWebglAvailable = undefined;

require('luma.gl');

var _globals = require('../utils/globals');

/* eslint-disable quotes, no-console */
/* global console */
var ERR_NO_HEADLESS_GL = 'Failed to dynamically load headless gl. gl not installed or not accessible from this directory.';

var luma = _globals.global.luma;
if (!_globals.isBrowser) {
  try {
    luma.globals.headlessGL = module.require('gl');
    luma.globals.headlessTypes = module.require('gl/wrap');
  } catch (error) {
    console.error(ERR_NO_HEADLESS_GL);
    console.error('Node error: ' + error.message);
  }
  var _luma$globals = luma.globals,
      headlessGL = _luma$globals.headlessGL,
      headlessTypes = _luma$globals.headlessTypes;

  if (headlessGL && !(headlessTypes && headlessTypes.WebGLRenderingContext)) {
    console.error('Could not access headless WebGL type definitions');
  }
}

var isWebglAvailable = exports.isWebglAvailable = _globals.isBrowser || luma.globals.headlessGL;

if (isWebglAvailable) {}
// console.log('WebGL initialized');


// Create context
exports.default = luma.globals.headlessGL;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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