'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.compressImage = compressImage;

var _assert = require('assert');

var _assert2 = _interopRequireDefault(_assert);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Returns data bytes representing a compressed image in PNG or JPG format,
 * This data can be saved using file system (f) methods or
 * used in a request.
 * @param {Image}  image - Image or Canvas
 * @param {String} opt.type='png' - png, jpg or image/png, image/jpg are valid
 * @param {String} opt.dataURI= - Whether to include a data URI header
 */
function compressImage(image, type) {
  if (image instanceof HTMLCanvasElement) {
    var _canvas = image;
    return _canvas.toDataURL(type);
  }

  (0, _assert2.default)(image instanceof Image, 'getImageData accepts image or canvas');
  var canvas = document.createElement('canvas');
  canvas.width = image.width;
  canvas.height = image.height;
  canvas.getContext('2d').drawImage(image, 0, 0);

  // Get raw image data
  var data = canvas.toDataURL(type || 'png').replace(/^data:image\/(png|jpg);base64,/, '');

  // Dump data into stream and return
  return new Buffer(data, 'base64');
} // Image loading/saving for browser
/* global document, HTMLCanvasElement, Image */
/* global Buffer */
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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