'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parseModel = exports.loadModel = exports.loadProgram = exports.loadTextures = exports.loadImages = exports.loadFiles = exports.setPathPrefix = undefined;

var _pathPrefix = require('./path-prefix');

Object.defineProperty(exports, 'setPathPrefix', {
  enumerable: true,
  get: function get() {
    return _pathPrefix.setPathPrefix;
  }
});

var _loadFiles = require('./load-files');

Object.defineProperty(exports, 'loadFiles', {
  enumerable: true,
  get: function get() {
    return _loadFiles.loadFiles;
  }
});
Object.defineProperty(exports, 'loadImages', {
  enumerable: true,
  get: function get() {
    return _loadFiles.loadImages;
  }
});

var _loadTextures = require('./load-textures');

Object.defineProperty(exports, 'loadTextures', {
  enumerable: true,
  get: function get() {
    return _loadTextures.loadTextures;
  }
});
Object.defineProperty(exports, 'loadProgram', {
  enumerable: true,
  get: function get() {
    return _loadTextures.loadProgram;
  }
});

var _jsonLoader = require('./json-loader');

Object.defineProperty(exports, 'loadModel', {
  enumerable: true,
  get: function get() {
    return _jsonLoader.loadModel;
  }
});
Object.defineProperty(exports, 'parseModel', {
  enumerable: true,
  get: function get() {
    return _jsonLoader.parseModel;
  }
});

var _globals = require('../utils/globals');

// Call a require based helper to select platform to export
if (_globals.isBrowser) {
  module.exports.loadFile = require('./browser-request-file');
  module.exports.loadImage = require('./browser-request-image');
  module.exports.readFile = require('./browser-read-file');
  var imageUtils = require('./browser-image-utils');
  Object.assign(module.exports, imageUtils);
} else {
  var fs = module.require('fs');
  // TODO - needs to be promisified...
  module.exports.readFile = fs && fs.readFile;
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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