'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

exports.loadTexture = loadTexture;
exports.loadProgram = loadProgram;
exports.loadTextures = loadTextures;

var _loadFiles = require('./load-files');

var _webgl = require('../webgl');

var _assert = require('assert');

var _assert2 = _interopRequireDefault(_assert);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function noop() {}

function loadTexture(gl, url) {
  var opts = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
  var urls = opts.urls,
      _opts$onProgress = opts.onProgress,
      onProgress = _opts$onProgress === undefined ? noop : _opts$onProgress;

  (0, _assert2.default)(typeof url === 'string', 'loadTexture: url must be string');

  return (0, _loadFiles.loadImages)(Object.assign({ urls: urls, onProgress: onProgress }, opts)).then(function (images) {
    return images.map(function (img, i) {
      return new _webgl.Texture2D(gl, Object.assign({ id: urls[i] }, opts, { data: img }));
    });
  });
}

function loadProgram(gl) {
  var opts = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var vs = opts.vs,
      fs = opts.fs,
      _opts$onProgress2 = opts.onProgress,
      onProgress = _opts$onProgress2 === undefined ? noop : _opts$onProgress2;

  return (0, _loadFiles.loadFiles)(Object.assign({ urls: [vs, fs], onProgress: onProgress }, opts)).then(function (_ref) {
    var _ref2 = _slicedToArray(_ref, 2),
        vsText = _ref2[0],
        fsText = _ref2[1];

    return new _webgl.Program(gl, Object.assign({ vs: vsText, fs: fsText }, opts));
  });
}

function loadTextures(gl) {
  var opts = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var urls = opts.urls,
      _opts$onProgress3 = opts.onProgress,
      onProgress = _opts$onProgress3 === undefined ? noop : _opts$onProgress3;

  (0, _assert2.default)(urls.every(function (url) {
    return typeof url === 'string';
  }), 'loadTextures: {urls} must be array of strings');

  return (0, _loadFiles.loadImages)(Object.assign({ urls: urls, onProgress: onProgress }, opts)).then(function (images) {
    return images.map(function (img, i) {
      var params = Array.isArray(opts.parameters) ? opts.parameters[i] : opts.parameters;
      params = params === undefined ? {} : params;
      return new _webgl.Texture2D(gl, Object.assign({ id: urls[i] }, params, { data: img }));
    });
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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