'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.compressImage = compressImage;

var _assert = require('assert');

var _assert2 = _interopRequireDefault(_assert);

var _through = require('through');

var _through2 = _interopRequireDefault(_through);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// Note: through adds stream support

/*
 * Returns data bytes representing a compressed image in PNG or JPG format,
 * This data can be saved using file system (f) methods or
 * used in a request.
 * @param {Image}  image - Image or Canvas
 * @param {String} opt.type='png' - png, jpg or image/png, image/jpg are valid
 * @param {String} opt.dataURI= - Whether to include a data URI header
 */
// Image loading/saving for browser
/* global document, HTMLCanvasElement, Image */

/* global process, Buffer */
function compressImage(image, type) {
  if (image instanceof HTMLCanvasElement) {
    var _canvas = image;
    return _canvas.toDataURL(type);
  }

  (0, _assert2.default)(image instanceof Image, 'getImageData accepts image or canvas');
  var canvas = document.createElement('canvas');
  canvas.width = image.width;
  canvas.height = image.height;
  canvas.getContext('2d').drawImage(image, 0, 0);

  // Get raw image data
  var data = canvas.toDataURL(type || 'png').replace(/^data:image\/(png|jpg);base64,/, '');

  // Dump data into stream and return
  var result = (0, _through2.default)();
  process.nextTick(function () {
    return result.end(new Buffer(data, 'base64'));
  });
  return result;
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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