// Copyright (c) 2015 - 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

export default "#define SHADER_NAME arc-layer-vertex-shader-64\n\nattribute vec3 positions;\nattribute vec4 instanceSourceColors;\nattribute vec4 instanceTargetColors;\n\nattribute vec4 instancePositions;\nattribute vec4 instancePositions64Low;\n\nattribute vec3 instancePickingColors;\n\nuniform float numSegments;\nuniform float strokeWidth;\nuniform float opacity;\n\nvarying vec4 vColor;\n\nvec2 paraboloid_fp64(vec2 source[2], vec2 target[2], float ratio) {\n\n  vec2 x[2];\n  vec2_mix_fp64(source, target, ratio, x);\n  vec2 center[2];\n  vec2_mix_fp64(source, target, 0.5, center);\n\n  vec2 dSourceCenter = vec2_distance_fp64(source, center);\n  vec2 dXCenter = vec2_distance_fp64(x, center);\n  return mul_fp64(sum_fp64(dSourceCenter, dXCenter), sub_fp64(dSourceCenter, dXCenter));\n}\n\n// offset vector by strokeWidth pixels\n// offset_direction is -1 (left) or 1 (right)\nvec2 getExtrusionOffset(vec2 line_clipspace, float offset_direction) {\n  // normalized direction of the line\n  vec2 dir_screenspace = normalize(line_clipspace * project_uViewportSize);\n  // rotate by 90 degrees\n  dir_screenspace = vec2(-dir_screenspace.y, dir_screenspace.x);\n\n  vec2 offset_screenspace = dir_screenspace * offset_direction * strokeWidth / 2.0;\n  vec2 offset_clipspace = project_pixel_to_clipspace(offset_screenspace).xy;\n\n  return offset_clipspace;\n}\n\nfloat getSegmentRatio(float index) {\n  return smoothstep(0.0, 1.0, index / (numSegments - 1.0));\n}\n\nvoid get_pos_fp64(vec2 source[2], vec2 target[2], float segmentRatio, out vec2 position[4]) {\n\n  vec2 vertex_height = paraboloid_fp64(source, target, segmentRatio);\n\n  vec2 position_temp[2];\n\n  vec2_mix_fp64(source, target, segmentRatio, position_temp);\n\n  position[0] = position_temp[0];\n  position[1] = position_temp[1];\n\n  if (vertex_height.x < 0.0 || (vertex_height.x == 0.0 && vertex_height.y <= 0.0)) {\n    vertex_height = vec2(0.0, 0.0);\n  }\n\n  position[2] = sqrt_fp64(vertex_height);\n  position[3] = vec2(1.0, 0.0);\n}\n\nvoid main(void) {\n  vec4 instanceSourcePositions64 = vec4(instancePositions.x,\n    instancePositions64Low.x, instancePositions.y, instancePositions64Low.y);\n  vec4 instanceTargetPositions64 = vec4(instancePositions.z,\n    instancePositions64Low.z, instancePositions.w, instancePositions64Low.w);\n\n  vec2 projected_source_coord[2];\n  vec2 projected_target_coord[2];\n\n  project_position_fp64(instanceSourcePositions64, projected_source_coord);\n  project_position_fp64(instanceTargetPositions64, projected_target_coord);\n\n  float segmentIndex = positions.x;\n  float segmentRatio = getSegmentRatio(segmentIndex);\n\n  // if it's the first point, use next - current as direction\n  // otherwise use current - prev\n  float indexDir = mix(-1.0, 1.0, step(segmentIndex, 0.0));\n  float nextSegmentRatio = getSegmentRatio(segmentIndex + indexDir);\n\n  vec2 curr_pos_modelspace[4];\n\n  get_pos_fp64(projected_source_coord, projected_target_coord, segmentRatio,\n    curr_pos_modelspace);\n\n  vec2 next_pos_modelspace[4];\n\n  get_pos_fp64(projected_source_coord, projected_target_coord, nextSegmentRatio,\n    next_pos_modelspace);\n\n  vec4 curr_pos_clipspace = project_to_clipspace_fp64(curr_pos_modelspace);\n  vec4 next_pos_clipspace = project_to_clipspace_fp64(next_pos_modelspace);\n\n  vec2 offset = getExtrusionOffset(next_pos_clipspace.xy - curr_pos_clipspace.xy, positions.y);\n\n  gl_Position = curr_pos_clipspace + vec4(offset, 0.0, 0.0);\n\n  vec4 color = mix(instanceSourceColors, instanceTargetColors, segmentRatio) / 255.;\n  vColor = vec4(color.rgb, color.a * opacity);\n\n  // Set color to be rendered to picking fbo (also used to check for selection highlight).\n  picking_setPickingColor(instancePickingColors);\n}\n";
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uLy4uL3NyYy9jb3JlLWxheWVycy9hcmMtbGF5ZXIvYXJjLWxheWVyLXZlcnRleC02NC5nbHNsLmpzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBIiwiZmlsZSI6ImFyYy1sYXllci12ZXJ0ZXgtNjQuZ2xzbC5qcyIsInNvdXJjZXNDb250ZW50IjpbIi8vIENvcHlyaWdodCAoYykgMjAxNSAtIDIwMTcgVWJlciBUZWNobm9sb2dpZXMsIEluYy5cbi8vXG4vLyBQZXJtaXNzaW9uIGlzIGhlcmVieSBncmFudGVkLCBmcmVlIG9mIGNoYXJnZSwgdG8gYW55IHBlcnNvbiBvYnRhaW5pbmcgYSBjb3B5XG4vLyBvZiB0aGlzIHNvZnR3YXJlIGFuZCBhc3NvY2lhdGVkIGRvY3VtZW50YXRpb24gZmlsZXMgKHRoZSBcIlNvZnR3YXJlXCIpLCB0byBkZWFsXG4vLyBpbiB0aGUgU29mdHdhcmUgd2l0aG91dCByZXN0cmljdGlvbiwgaW5jbHVkaW5nIHdpdGhvdXQgbGltaXRhdGlvbiB0aGUgcmlnaHRzXG4vLyB0byB1c2UsIGNvcHksIG1vZGlmeSwgbWVyZ2UsIHB1Ymxpc2gsIGRpc3RyaWJ1dGUsIHN1YmxpY2Vuc2UsIGFuZC9vciBzZWxsXG4vLyBjb3BpZXMgb2YgdGhlIFNvZnR3YXJlLCBhbmQgdG8gcGVybWl0IHBlcnNvbnMgdG8gd2hvbSB0aGUgU29mdHdhcmUgaXNcbi8vIGZ1cm5pc2hlZCB0byBkbyBzbywgc3ViamVjdCB0byB0aGUgZm9sbG93aW5nIGNvbmRpdGlvbnM6XG4vL1xuLy8gVGhlIGFib3ZlIGNvcHlyaWdodCBub3RpY2UgYW5kIHRoaXMgcGVybWlzc2lvbiBub3RpY2Ugc2hhbGwgYmUgaW5jbHVkZWQgaW5cbi8vIGFsbCBjb3BpZXMgb3Igc3Vic3RhbnRpYWwgcG9ydGlvbnMgb2YgdGhlIFNvZnR3YXJlLlxuLy9cbi8vIFRIRSBTT0ZUV0FSRSBJUyBQUk9WSURFRCBcIkFTIElTXCIsIFdJVEhPVVQgV0FSUkFOVFkgT0YgQU5ZIEtJTkQsIEVYUFJFU1MgT1Jcbi8vIElNUExJRUQsIElOQ0xVRElORyBCVVQgTk9UIExJTUlURUQgVE8gVEhFIFdBUlJBTlRJRVMgT0YgTUVSQ0hBTlRBQklMSVRZLFxuLy8gRklUTkVTUyBGT1IgQSBQQVJUSUNVTEFSIFBVUlBPU0UgQU5EIE5PTklORlJJTkdFTUVOVC4gSU4gTk8gRVZFTlQgU0hBTEwgVEhFXG4vLyBBVVRIT1JTIE9SIENPUFlSSUdIVCBIT0xERVJTIEJFIExJQUJMRSBGT1IgQU5ZIENMQUlNLCBEQU1BR0VTIE9SIE9USEVSXG4vLyBMSUFCSUxJVFksIFdIRVRIRVIgSU4gQU4gQUNUSU9OIE9GIENPTlRSQUNULCBUT1JUIE9SIE9USEVSV0lTRSwgQVJJU0lORyBGUk9NLFxuLy8gT1VUIE9GIE9SIElOIENPTk5FQ1RJT04gV0lUSCBUSEUgU09GVFdBUkUgT1IgVEhFIFVTRSBPUiBPVEhFUiBERUFMSU5HUyBJTlxuLy8gVEhFIFNPRlRXQVJFLlxuXG5leHBvcnQgZGVmYXVsdCBgXFxcbiNkZWZpbmUgU0hBREVSX05BTUUgYXJjLWxheWVyLXZlcnRleC1zaGFkZXItNjRcblxuYXR0cmlidXRlIHZlYzMgcG9zaXRpb25zO1xuYXR0cmlidXRlIHZlYzQgaW5zdGFuY2VTb3VyY2VDb2xvcnM7XG5hdHRyaWJ1dGUgdmVjNCBpbnN0YW5jZVRhcmdldENvbG9ycztcblxuYXR0cmlidXRlIHZlYzQgaW5zdGFuY2VQb3NpdGlvbnM7XG5hdHRyaWJ1dGUgdmVjNCBpbnN0YW5jZVBvc2l0aW9uczY0TG93O1xuXG5hdHRyaWJ1dGUgdmVjMyBpbnN0YW5jZVBpY2tpbmdDb2xvcnM7XG5cbnVuaWZvcm0gZmxvYXQgbnVtU2VnbWVudHM7XG51bmlmb3JtIGZsb2F0IHN0cm9rZVdpZHRoO1xudW5pZm9ybSBmbG9hdCBvcGFjaXR5O1xuXG52YXJ5aW5nIHZlYzQgdkNvbG9yO1xuXG52ZWMyIHBhcmFib2xvaWRfZnA2NCh2ZWMyIHNvdXJjZVsyXSwgdmVjMiB0YXJnZXRbMl0sIGZsb2F0IHJhdGlvKSB7XG5cbiAgdmVjMiB4WzJdO1xuICB2ZWMyX21peF9mcDY0KHNvdXJjZSwgdGFyZ2V0LCByYXRpbywgeCk7XG4gIHZlYzIgY2VudGVyWzJdO1xuICB2ZWMyX21peF9mcDY0KHNvdXJjZSwgdGFyZ2V0LCAwLjUsIGNlbnRlcik7XG5cbiAgdmVjMiBkU291cmNlQ2VudGVyID0gdmVjMl9kaXN0YW5jZV9mcDY0KHNvdXJjZSwgY2VudGVyKTtcbiAgdmVjMiBkWENlbnRlciA9IHZlYzJfZGlzdGFuY2VfZnA2NCh4LCBjZW50ZXIpO1xuICByZXR1cm4gbXVsX2ZwNjQoc3VtX2ZwNjQoZFNvdXJjZUNlbnRlciwgZFhDZW50ZXIpLCBzdWJfZnA2NChkU291cmNlQ2VudGVyLCBkWENlbnRlcikpO1xufVxuXG4vLyBvZmZzZXQgdmVjdG9yIGJ5IHN0cm9rZVdpZHRoIHBpeGVsc1xuLy8gb2Zmc2V0X2RpcmVjdGlvbiBpcyAtMSAobGVmdCkgb3IgMSAocmlnaHQpXG52ZWMyIGdldEV4dHJ1c2lvbk9mZnNldCh2ZWMyIGxpbmVfY2xpcHNwYWNlLCBmbG9hdCBvZmZzZXRfZGlyZWN0aW9uKSB7XG4gIC8vIG5vcm1hbGl6ZWQgZGlyZWN0aW9uIG9mIHRoZSBsaW5lXG4gIHZlYzIgZGlyX3NjcmVlbnNwYWNlID0gbm9ybWFsaXplKGxpbmVfY2xpcHNwYWNlICogcHJvamVjdF91Vmlld3BvcnRTaXplKTtcbiAgLy8gcm90YXRlIGJ5IDkwIGRlZ3JlZXNcbiAgZGlyX3NjcmVlbnNwYWNlID0gdmVjMigtZGlyX3NjcmVlbnNwYWNlLnksIGRpcl9zY3JlZW5zcGFjZS54KTtcblxuICB2ZWMyIG9mZnNldF9zY3JlZW5zcGFjZSA9IGRpcl9zY3JlZW5zcGFjZSAqIG9mZnNldF9kaXJlY3Rpb24gKiBzdHJva2VXaWR0aCAvIDIuMDtcbiAgdmVjMiBvZmZzZXRfY2xpcHNwYWNlID0gcHJvamVjdF9waXhlbF90b19jbGlwc3BhY2Uob2Zmc2V0X3NjcmVlbnNwYWNlKS54eTtcblxuICByZXR1cm4gb2Zmc2V0X2NsaXBzcGFjZTtcbn1cblxuZmxvYXQgZ2V0U2VnbWVudFJhdGlvKGZsb2F0IGluZGV4KSB7XG4gIHJldHVybiBzbW9vdGhzdGVwKDAuMCwgMS4wLCBpbmRleCAvIChudW1TZWdtZW50cyAtIDEuMCkpO1xufVxuXG52b2lkIGdldF9wb3NfZnA2NCh2ZWMyIHNvdXJjZVsyXSwgdmVjMiB0YXJnZXRbMl0sIGZsb2F0IHNlZ21lbnRSYXRpbywgb3V0IHZlYzIgcG9zaXRpb25bNF0pIHtcblxuICB2ZWMyIHZlcnRleF9oZWlnaHQgPSBwYXJhYm9sb2lkX2ZwNjQoc291cmNlLCB0YXJnZXQsIHNlZ21lbnRSYXRpbyk7XG5cbiAgdmVjMiBwb3NpdGlvbl90ZW1wWzJdO1xuXG4gIHZlYzJfbWl4X2ZwNjQoc291cmNlLCB0YXJnZXQsIHNlZ21lbnRSYXRpbywgcG9zaXRpb25fdGVtcCk7XG5cbiAgcG9zaXRpb25bMF0gPSBwb3NpdGlvbl90ZW1wWzBdO1xuICBwb3NpdGlvblsxXSA9IHBvc2l0aW9uX3RlbXBbMV07XG5cbiAgaWYgKHZlcnRleF9oZWlnaHQueCA8IDAuMCB8fCAodmVydGV4X2hlaWdodC54ID09IDAuMCAmJiB2ZXJ0ZXhfaGVpZ2h0LnkgPD0gMC4wKSkge1xuICAgIHZlcnRleF9oZWlnaHQgPSB2ZWMyKDAuMCwgMC4wKTtcbiAgfVxuXG4gIHBvc2l0aW9uWzJdID0gc3FydF9mcDY0KHZlcnRleF9oZWlnaHQpO1xuICBwb3NpdGlvblszXSA9IHZlYzIoMS4wLCAwLjApO1xufVxuXG52b2lkIG1haW4odm9pZCkge1xuICB2ZWM0IGluc3RhbmNlU291cmNlUG9zaXRpb25zNjQgPSB2ZWM0KGluc3RhbmNlUG9zaXRpb25zLngsXG4gICAgaW5zdGFuY2VQb3NpdGlvbnM2NExvdy54LCBpbnN0YW5jZVBvc2l0aW9ucy55LCBpbnN0YW5jZVBvc2l0aW9uczY0TG93LnkpO1xuICB2ZWM0IGluc3RhbmNlVGFyZ2V0UG9zaXRpb25zNjQgPSB2ZWM0KGluc3RhbmNlUG9zaXRpb25zLnosXG4gICAgaW5zdGFuY2VQb3NpdGlvbnM2NExvdy56LCBpbnN0YW5jZVBvc2l0aW9ucy53LCBpbnN0YW5jZVBvc2l0aW9uczY0TG93LncpO1xuXG4gIHZlYzIgcHJvamVjdGVkX3NvdXJjZV9jb29yZFsyXTtcbiAgdmVjMiBwcm9qZWN0ZWRfdGFyZ2V0X2Nvb3JkWzJdO1xuXG4gIHByb2plY3RfcG9zaXRpb25fZnA2NChpbnN0YW5jZVNvdXJjZVBvc2l0aW9uczY0LCBwcm9qZWN0ZWRfc291cmNlX2Nvb3JkKTtcbiAgcHJvamVjdF9wb3NpdGlvbl9mcDY0KGluc3RhbmNlVGFyZ2V0UG9zaXRpb25zNjQsIHByb2plY3RlZF90YXJnZXRfY29vcmQpO1xuXG4gIGZsb2F0IHNlZ21lbnRJbmRleCA9IHBvc2l0aW9ucy54O1xuICBmbG9hdCBzZWdtZW50UmF0aW8gPSBnZXRTZWdtZW50UmF0aW8oc2VnbWVudEluZGV4KTtcblxuICAvLyBpZiBpdCdzIHRoZSBmaXJzdCBwb2ludCwgdXNlIG5leHQgLSBjdXJyZW50IGFzIGRpcmVjdGlvblxuICAvLyBvdGhlcndpc2UgdXNlIGN1cnJlbnQgLSBwcmV2XG4gIGZsb2F0IGluZGV4RGlyID0gbWl4KC0xLjAsIDEuMCwgc3RlcChzZWdtZW50SW5kZXgsIDAuMCkpO1xuICBmbG9hdCBuZXh0U2VnbWVudFJhdGlvID0gZ2V0U2VnbWVudFJhdGlvKHNlZ21lbnRJbmRleCArIGluZGV4RGlyKTtcblxuICB2ZWMyIGN1cnJfcG9zX21vZGVsc3BhY2VbNF07XG5cbiAgZ2V0X3Bvc19mcDY0KHByb2plY3RlZF9zb3VyY2VfY29vcmQsIHByb2plY3RlZF90YXJnZXRfY29vcmQsIHNlZ21lbnRSYXRpbyxcbiAgICBjdXJyX3Bvc19tb2RlbHNwYWNlKTtcblxuICB2ZWMyIG5leHRfcG9zX21vZGVsc3BhY2VbNF07XG5cbiAgZ2V0X3Bvc19mcDY0KHByb2plY3RlZF9zb3VyY2VfY29vcmQsIHByb2plY3RlZF90YXJnZXRfY29vcmQsIG5leHRTZWdtZW50UmF0aW8sXG4gICAgbmV4dF9wb3NfbW9kZWxzcGFjZSk7XG5cbiAgdmVjNCBjdXJyX3Bvc19jbGlwc3BhY2UgPSBwcm9qZWN0X3RvX2NsaXBzcGFjZV9mcDY0KGN1cnJfcG9zX21vZGVsc3BhY2UpO1xuICB2ZWM0IG5leHRfcG9zX2NsaXBzcGFjZSA9IHByb2plY3RfdG9fY2xpcHNwYWNlX2ZwNjQobmV4dF9wb3NfbW9kZWxzcGFjZSk7XG5cbiAgdmVjMiBvZmZzZXQgPSBnZXRFeHRydXNpb25PZmZzZXQobmV4dF9wb3NfY2xpcHNwYWNlLnh5IC0gY3Vycl9wb3NfY2xpcHNwYWNlLnh5LCBwb3NpdGlvbnMueSk7XG5cbiAgZ2xfUG9zaXRpb24gPSBjdXJyX3Bvc19jbGlwc3BhY2UgKyB2ZWM0KG9mZnNldCwgMC4wLCAwLjApO1xuXG4gIHZlYzQgY29sb3IgPSBtaXgoaW5zdGFuY2VTb3VyY2VDb2xvcnMsIGluc3RhbmNlVGFyZ2V0Q29sb3JzLCBzZWdtZW50UmF0aW8pIC8gMjU1LjtcbiAgdkNvbG9yID0gdmVjNChjb2xvci5yZ2IsIGNvbG9yLmEgKiBvcGFjaXR5KTtcblxuICAvLyBTZXQgY29sb3IgdG8gYmUgcmVuZGVyZWQgdG8gcGlja2luZyBmYm8gKGFsc28gdXNlZCB0byBjaGVjayBmb3Igc2VsZWN0aW9uIGhpZ2hsaWdodCkuXG4gIHBpY2tpbmdfc2V0UGlja2luZ0NvbG9yKGluc3RhbmNlUGlja2luZ0NvbG9ycyk7XG59XG5gO1xuIl19