// Copyright (c) 2015 - 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

export default "#define SHADER_NAME arc-layer-vertex-shader\n\nattribute vec3 positions;\nattribute vec4 instanceSourceColors;\nattribute vec4 instanceTargetColors;\nattribute vec4 instancePositions;\nattribute vec3 instancePickingColors;\n\nuniform float numSegments;\nuniform float strokeWidth;\nuniform float opacity;\n\nvarying vec4 vColor;\n\nfloat paraboloid(vec2 source, vec2 target, float ratio) {\n\n  vec2 x = mix(source, target, ratio);\n  vec2 center = mix(source, target, 0.5);\n\n  float dSourceCenter = distance(source, center);\n  float dXCenter = distance(x, center);\n  return (dSourceCenter + dXCenter) * (dSourceCenter - dXCenter);\n}\n\n// offset vector by strokeWidth pixels\n// offset_direction is -1 (left) or 1 (right)\nvec2 getExtrusionOffset(vec2 line_clipspace, float offset_direction) {\n  // normalized direction of the line\n  vec2 dir_screenspace = normalize(line_clipspace * project_uViewportSize);\n  // rotate by 90 degrees\n  dir_screenspace = vec2(-dir_screenspace.y, dir_screenspace.x);\n\n  vec2 offset_screenspace = dir_screenspace * offset_direction * strokeWidth / 2.0;\n  vec2 offset_clipspace = project_pixel_to_clipspace(offset_screenspace).xy;\n\n  return offset_clipspace;\n}\n\nfloat getSegmentRatio(float index) {\n  return smoothstep(0.0, 1.0, index / (numSegments - 1.0));\n}\n\nvec3 getPos(vec2 source, vec2 target, float segmentRatio) {\n  float vertex_height = paraboloid(source, target, segmentRatio);\n\n  return vec3(\n    mix(source, target, segmentRatio),\n    sqrt(max(0.0, vertex_height))\n  );\n}\n\nvoid main(void) {\n  vec2 source = project_position(instancePositions.xy);\n  vec2 target = project_position(instancePositions.zw);\n\n  float segmentIndex = positions.x;\n  float segmentRatio = getSegmentRatio(segmentIndex);\n  // if it's the first point, use next - current as direction\n  // otherwise use current - prev\n  float indexDir = mix(-1.0, 1.0, step(segmentIndex, 0.0));\n  float nextSegmentRatio = getSegmentRatio(segmentIndex + indexDir);\n\n  vec3 currPos = getPos(source, target, segmentRatio);\n  vec3 nextPos = getPos(source, target, nextSegmentRatio);\n  vec4 curr = project_to_clipspace(vec4(currPos, 1.0));\n  vec4 next = project_to_clipspace(vec4(nextPos, 1.0));\n\n  // extrude\n  vec2 offset = getExtrusionOffset((next.xy - curr.xy) * indexDir, positions.y);\n  gl_Position = curr + vec4(offset, 0.0, 0.0);\n\n  vec4 color = mix(instanceSourceColors, instanceTargetColors, segmentRatio) / 255.;\n  vColor = vec4(color.rgb, color.a * opacity);\n\n  // Set color to be rendered to picking fbo (also used to check for selection highlight).\n  picking_setPickingColor(instancePickingColors);\n}\n";
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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