// Copyright (c) 2015 - 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// Inspired by screen-grid-layer vertex shader in deck.gl

export default "#define SHADER_NAME grid-cell-layer-vertex-shader-64\n\nattribute vec3 positions;\nattribute vec3 normals;\n\nattribute vec4 instancePositions;\nattribute vec2 instancePositions64xyLow;\nattribute vec4 instanceColors;\nattribute vec3 instancePickingColors;\n\n// Custom uniforms\nuniform float extruded;\nuniform float cellSize;\nuniform float coverage;\nuniform float opacity;\nuniform float elevationScale;\n\n// A magic number to scale elevation so that 1 unit approximate to 1 meter\n#define ELEVATION_SCALE 0.8\n\n// Result\nvarying vec4 vColor;\n\nvoid main(void) {\n  vec4 instancePositions64xy = vec4(\n    instancePositions.x,\n    instancePositions64xyLow.x,\n    instancePositions.y,\n    instancePositions64xyLow.y);\n\n  vec2 projected_coord_xy[2];\n  project_position_fp64(instancePositions64xy, projected_coord_xy);\n\n  // if ahpha == 0.0 or z < 0.0, do not render element\n  float noRender = float(instanceColors.a == 0.0 || instancePositions.w < 0.0);\n  float finalCellSize = cellSize * mix(1.0, 0.0, noRender);\n\n  projected_coord_xy[0] = sum_fp64(projected_coord_xy[0],\n    vec2((positions.x * coverage + 1.0) * finalCellSize / 2.0, 0.0));\n  projected_coord_xy[1] = sum_fp64(projected_coord_xy[1],\n    vec2((positions.y * coverage - 1.0) * finalCellSize / 2.0, 0.0));\n\n  float elevation = 0.0;\n\n  if (extruded > 0.5) {\n    elevation = project_scale(instancePositions.w  * (positions.z + 1.0) *\n      ELEVATION_SCALE * elevationScale) + 1.0;\n  }\n\n  vec2 vertex_pos_modelspace[4];\n  vertex_pos_modelspace[0] = projected_coord_xy[0];\n  vertex_pos_modelspace[1] = projected_coord_xy[1];\n  vertex_pos_modelspace[2] = vec2(elevation, 0.0);\n  vertex_pos_modelspace[3] = vec2(1.0, 0.0);\n\n  vec4 position_worldspace = vec4(\n    vertex_pos_modelspace[0].x, vertex_pos_modelspace[1].x,\n    vertex_pos_modelspace[2].x, vertex_pos_modelspace[3].x);\n\n  gl_Position = project_to_clipspace_fp64(vertex_pos_modelspace);\n\n  float lightWeight = 1.0;\n\n  if (extruded > 0.5) {\n    lightWeight = getLightWeight(\n      position_worldspace.xyz, // the w component is always 1.0\n      normals\n    );\n  }\n\n  vec3 lightWeightedColor = lightWeight * instanceColors.rgb;\n  vec4 color = vec4(lightWeightedColor, instanceColors.a * opacity) / 255.0;\n  vColor = color;\n\n  // Set color to be rendered to picking fbo (also used to check for selection highlight).\n  picking_setPickingColor(instancePickingColors);\n}\n";
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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