var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

// Copyright (c) 2015 - 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

import { CompositeLayer, experimental } from '../../core';
var BinSorter = experimental.BinSorter,
    defaultColorRange = experimental.defaultColorRange,
    getQuantizeScale = experimental.getQuantizeScale,
    getLinearScale = experimental.getLinearScale;


import GridCellLayer from '../grid-cell-layer/grid-cell-layer';

import { pointToDensityGridData } from './grid-aggregator';

function nop() {}

var defaultProps = {
  // color
  colorDomain: null,
  colorRange: defaultColorRange,
  getColorValue: function getColorValue(points) {
    return points.length;
  },
  lowerPercentile: 0,
  upperPercentile: 100,
  onSetColorDomain: nop,

  // elevation
  elevationDomain: null,
  elevationRange: [0, 1000],
  getElevationValue: function getElevationValue(points) {
    return points.length;
  },
  elevationLowerPercentile: 0,
  elevationUpperPercentile: 100,
  elevationScale: 1,
  onSetElevationDomain: nop,

  // grid
  cellSize: 1000,
  coverage: 1,
  getPosition: function getPosition(x) {
    return x.position;
  },
  extruded: false,
  fp64: false,
  // Optional settings for 'lighting' shader module
  lightSettings: {
    lightsPosition: [-122.45, 37.75, 8000, -122.0, 38.0, 5000],
    ambientRatio: 0.05,
    diffuseRatio: 0.6,
    specularRatio: 0.8,
    lightsStrength: [2.0, 0.0, 0.0, 0.0],
    numberOfLights: 2
  }
};

var GridLayer = function (_CompositeLayer) {
  _inherits(GridLayer, _CompositeLayer);

  function GridLayer() {
    _classCallCheck(this, GridLayer);

    return _possibleConstructorReturn(this, (GridLayer.__proto__ || Object.getPrototypeOf(GridLayer)).apply(this, arguments));
  }

  _createClass(GridLayer, [{
    key: 'initializeState',
    value: function initializeState() {
      this.state = {
        layerData: [],
        sortedColorBins: null,
        sortedElevationBins: null,
        colorValueDomain: null,
        elevationValueDomain: null,
        colorScaleFunc: nop,
        elevationScaleFunc: nop,
        dimensionUpdaters: this.getDimensionUpdaters()
      };
    }
  }, {
    key: 'updateState',
    value: function updateState(_ref) {
      var _this2 = this;

      var oldProps = _ref.oldProps,
          props = _ref.props,
          changeFlags = _ref.changeFlags;

      var dimensionChanges = this.getDimensionChanges(oldProps, props);

      if (changeFlags.dataChanged || this.needsReProjectPoints(oldProps, props)) {
        // project data into hexagons, and get sortedBins
        this.getLayerData();
      } else if (dimensionChanges) {
        dimensionChanges.forEach(function (f) {
          return typeof f === 'function' && f.apply(_this2);
        });
      }
    }
  }, {
    key: 'needsReProjectPoints',
    value: function needsReProjectPoints(oldProps, props) {
      return oldProps.cellSize !== props.cellSize;
    }
  }, {
    key: 'getDimensionUpdaters',
    value: function getDimensionUpdaters() {
      // dimension updaters are sequential,
      // if the first one needs to be called, the 2nd and 3rd one will automatically
      // be called. e.g. if ColorValue needs to be updated, getColorValueDomain and getColorScale
      // will automatically be called
      return {
        getColor: [{
          id: 'value',
          triggers: ['getColorValue'],
          updater: this.getSortedColorBins
        }, {
          id: 'domain',
          triggers: ['lowerPercentile', 'upperPercentile'],
          updater: this.getColorValueDomain
        }, {
          id: 'scaleFunc',
          triggers: ['colorDomain', 'colorRange'],
          updater: this.getColorScale
        }],
        getElevation: [{
          id: 'value',
          triggers: ['getElevationValue'],
          updater: this.getSortedElevationBins
        }, {
          id: 'domain',
          triggers: ['elevationLowerPercentile', 'elevationUpperPercentile'],
          updater: this.getElevationValueDomain
        }, {
          id: 'scaleFunc',
          triggers: ['elevationDomain', 'elevationRange'],
          updater: this.getElevationScale
        }]
      };
    }
  }, {
    key: 'getDimensionChanges',
    value: function getDimensionChanges(oldProps, props) {
      var dimensionUpdaters = this.state.dimensionUpdaters;

      var updaters = [];

      // get dimension to be updated
      for (var dimensionKey in dimensionUpdaters) {
        // return the first triggered updater for each dimension
        var needUpdate = dimensionUpdaters[dimensionKey].find(function (item) {
          return item.triggers.some(function (t) {
            return oldProps[t] !== props[t];
          });
        });

        if (needUpdate) {
          updaters.push(needUpdate.updater);
        }
      }

      return updaters.length ? updaters : null;
    }
  }, {
    key: 'getPickingInfo',
    value: function getPickingInfo(_ref2) {
      var info = _ref2.info;
      var _state = this.state,
          sortedColorBins = _state.sortedColorBins,
          sortedElevationBins = _state.sortedElevationBins;


      var isPicked = info.picked && info.index > -1;
      var object = null;

      if (isPicked) {
        var cell = this.state.layerData[info.index];

        var colorValue = sortedColorBins.binMap[cell.index] && sortedColorBins.binMap[cell.index].value;
        var elevationValue = sortedElevationBins.binMap[cell.index] && sortedElevationBins.binMap[cell.index].value;

        object = Object.assign({
          colorValue: colorValue,
          elevationValue: elevationValue
        }, cell);
      }

      // add bin colorValue and elevationValue to info
      return Object.assign(info, {
        picked: Boolean(object),
        // override object with picked cell
        object: object
      });
    }
  }, {
    key: 'getUpdateTriggers',
    value: function getUpdateTriggers() {
      var _this3 = this;

      var dimensionUpdaters = this.state.dimensionUpdaters;

      // merge all dimension triggers

      var updateTriggers = {};

      var _loop = function _loop(dimensionKey) {
        updateTriggers[dimensionKey] = {};

        var _iteratorNormalCompletion = true;
        var _didIteratorError = false;
        var _iteratorError = undefined;

        try {
          for (var _iterator = dimensionUpdaters[dimensionKey][Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
            var step = _step.value;

            step.triggers.forEach(function (prop) {
              updateTriggers[dimensionKey][prop] = _this3.props[prop];
            });
          }
        } catch (err) {
          _didIteratorError = true;
          _iteratorError = err;
        } finally {
          try {
            if (!_iteratorNormalCompletion && _iterator.return) {
              _iterator.return();
            }
          } finally {
            if (_didIteratorError) {
              throw _iteratorError;
            }
          }
        }
      };

      for (var dimensionKey in dimensionUpdaters) {
        _loop(dimensionKey);
      }

      return updateTriggers;
    }
  }, {
    key: 'getLayerData',
    value: function getLayerData() {
      var _props = this.props,
          data = _props.data,
          cellSize = _props.cellSize,
          getPosition = _props.getPosition;

      var _pointToDensityGridDa = pointToDensityGridData(data, cellSize, getPosition),
          layerData = _pointToDensityGridDa.layerData;

      this.setState({ layerData: layerData });
      this.getSortedBins();
    }
  }, {
    key: 'getValueDomain',
    value: function getValueDomain() {
      this.getColorValueDomain();
      this.getElevationValueDomain();
    }
  }, {
    key: 'getSortedBins',
    value: function getSortedBins() {
      this.getSortedColorBins();
      this.getSortedElevationBins();
    }
  }, {
    key: 'getSortedColorBins',
    value: function getSortedColorBins() {
      var getColorValue = this.props.getColorValue;

      var sortedColorBins = new BinSorter(this.state.layerData || [], getColorValue);

      this.setState({ sortedColorBins: sortedColorBins });
      this.getColorValueDomain();
    }
  }, {
    key: 'getSortedElevationBins',
    value: function getSortedElevationBins() {
      var getElevationValue = this.props.getElevationValue;

      var sortedElevationBins = new BinSorter(this.state.layerData || [], getElevationValue);
      this.setState({ sortedElevationBins: sortedElevationBins });
      this.getElevationValueDomain();
    }
  }, {
    key: 'getColorValueDomain',
    value: function getColorValueDomain() {
      var _props2 = this.props,
          lowerPercentile = _props2.lowerPercentile,
          upperPercentile = _props2.upperPercentile,
          onSetColorDomain = _props2.onSetColorDomain;


      this.state.colorValueDomain = this.state.sortedColorBins.getValueRange([lowerPercentile, upperPercentile]);

      if (typeof onSetColorDomain === 'function') {
        onSetColorDomain(this.state.colorValueDomain);
      }

      this.getColorScale();
    }
  }, {
    key: 'getElevationValueDomain',
    value: function getElevationValueDomain() {
      var _props3 = this.props,
          elevationLowerPercentile = _props3.elevationLowerPercentile,
          elevationUpperPercentile = _props3.elevationUpperPercentile,
          onSetElevationDomain = _props3.onSetElevationDomain;


      this.state.elevationValueDomain = this.state.sortedElevationBins.getValueRange([elevationLowerPercentile, elevationUpperPercentile]);

      if (typeof onSetElevationDomain === 'function') {
        onSetElevationDomain(this.state.elevationValueDomain);
      }

      this.getElevationScale();
    }
  }, {
    key: 'getColorScale',
    value: function getColorScale() {
      var colorRange = this.props.colorRange;

      var colorDomain = this.props.colorDomain || this.state.colorValueDomain;

      this.state.colorScaleFunc = getQuantizeScale(colorDomain, colorRange);
    }
  }, {
    key: 'getElevationScale',
    value: function getElevationScale() {
      var elevationRange = this.props.elevationRange;

      var elevationDomain = this.props.elevationDomain || this.state.elevationValueDomain;

      this.state.elevationScaleFunc = getLinearScale(elevationDomain, elevationRange);
    }
  }, {
    key: '_onGetSublayerColor',
    value: function _onGetSublayerColor(cell) {
      var _state2 = this.state,
          sortedColorBins = _state2.sortedColorBins,
          colorScaleFunc = _state2.colorScaleFunc,
          colorValueDomain = _state2.colorValueDomain;


      var cv = sortedColorBins.binMap[cell.index] && sortedColorBins.binMap[cell.index].value;
      var colorDomain = this.props.colorDomain || colorValueDomain;

      var isColorValueInDomain = cv >= colorDomain[0] && cv <= colorDomain[colorDomain.length - 1];

      // if cell value is outside domain, set alpha to 0
      var color = isColorValueInDomain ? colorScaleFunc(cv) : [0, 0, 0, 0];

      // add alpha to color if not defined in colorRange
      color[3] = Number.isFinite(color[3]) ? color[3] : 255;

      return color;
    }
  }, {
    key: '_onGetSublayerElevation',
    value: function _onGetSublayerElevation(cell) {
      var _state3 = this.state,
          sortedElevationBins = _state3.sortedElevationBins,
          elevationScaleFunc = _state3.elevationScaleFunc,
          elevationValueDomain = _state3.elevationValueDomain;

      var ev = sortedElevationBins.binMap[cell.index] && sortedElevationBins.binMap[cell.index].value;

      var elevationDomain = this.props.elevationDomain || elevationValueDomain;

      var isElevationValueInDomain = ev >= elevationDomain[0] && ev <= elevationDomain[elevationDomain.length - 1];

      // if cell value is outside domain, set elevation to -1
      return isElevationValueInDomain ? elevationScaleFunc(ev) : -1;
    }

    // for subclassing, override this method to return
    // customized sub layer props

  }, {
    key: 'getSubLayerProps',
    value: function getSubLayerProps() {
      var _props4 = this.props,
          elevationScale = _props4.elevationScale,
          fp64 = _props4.fp64,
          extruded = _props4.extruded,
          cellSize = _props4.cellSize,
          coverage = _props4.coverage,
          lightSettings = _props4.lightSettings;

      // return props to the sublayer constructor

      return _get(GridLayer.prototype.__proto__ || Object.getPrototypeOf(GridLayer.prototype), 'getSubLayerProps', this).call(this, {
        id: 'grid-cell',
        data: this.state.layerData,

        fp64: fp64,
        cellSize: cellSize,
        coverage: coverage,
        lightSettings: lightSettings,
        elevationScale: elevationScale,
        extruded: extruded,

        getColor: this._onGetSublayerColor.bind(this),
        getElevation: this._onGetSublayerElevation.bind(this),
        updateTriggers: this.getUpdateTriggers()
      });
    }

    // for subclassing, override this method to return
    // customized sub layer class

  }, {
    key: 'getSubLayerClass',
    value: function getSubLayerClass() {
      return GridCellLayer;
    }
  }, {
    key: 'renderLayers',
    value: function renderLayers() {
      var SubLayerClass = this.getSubLayerClass();

      return new SubLayerClass(this.getSubLayerProps());
    }
  }]);

  return GridLayer;
}(CompositeLayer);

export default GridLayer;


GridLayer.layerName = 'GridLayer';
GridLayer.defaultProps = defaultProps;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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