// Copyright (c) 2015 - 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

export default "\n#define SHADER_NAME hexagon-cell-layer-vertex-shader\n\nattribute vec3 positions;\nattribute vec3 normals;\n\nattribute vec3 instancePositions;\nattribute vec4 instanceColors;\nattribute vec3 instancePickingColors;\n\n// Custom uniforms\nuniform float opacity;\nuniform float radius;\nuniform float angle;\nuniform float extruded;\nuniform float coverage;\nuniform float elevationScale;\n\n// Result\nvarying vec4 vColor;\n\n// A magic number to scale elevation so that 1 unit approximate to 1 meter.\n#define ELEVATION_SCALE 0.8\n\nvoid main(void) {\n\n  // rotate primitive position and normal\n  mat2 rotationMatrix = mat2(cos(angle), -sin(angle), sin(angle), cos(angle));\n\n  vec2 rPos = rotationMatrix * positions.xz;\n  vec2 rNorm = rotationMatrix * normals.xz; // the hexagon cells has y axis as the vertical axis\n\n  vec3 rotatedPositions = vec3(rPos.x, positions.y, rPos.y);\n  vec3 rotatedNormals = vec3(rNorm.x, rNorm.y, normals.y);\n\n  // calculate elevation, if 3d not enabled set to 0\n  // cylindar gemoetry height are between -0.5 to 0.5, transform it to between 0, 1\n  float elevation = 0.0;\n\n  if (extruded > 0.5) {\n    elevation = project_scale(instancePositions.z * (positions.y + 0.5) *\n      ELEVATION_SCALE * elevationScale);\n  }\n\n  // if ahpha == 0.0 or z < 0.0, do not render element\n  float noRender = float(instanceColors.a == 0.0 || instancePositions.z < 0.0);\n  float dotRadius = radius * mix(coverage, 0.0, noRender);\n\n  // project center of hexagon\n  vec4 centroidPosition = vec4(project_position(instancePositions.xy), elevation, 0.0);\n\n  vec4 position_worldspace = centroidPosition + vec4(vec2(rotatedPositions.xz * dotRadius), 0., 1.);\n\n  gl_Position = project_to_clipspace(position_worldspace);\n\n  // Light calculations\n  // Worldspace is the linear space after Mercator projection\n\n  vec3 normals_worldspace = rotatedNormals;\n\n  float lightWeight = 1.0;\n\n  if (extruded > 0.5) {\n    lightWeight = getLightWeight(\n      position_worldspace.xyz, // the w component is always 1.0\n      normals_worldspace\n    );\n  }\n\n  vec3 lightWeightedColor = lightWeight * instanceColors.rgb;\n\n  // opacity-multiplied instance color\n  vColor = vec4(lightWeightedColor, opacity * instanceColors.a) / 255.0;\n\n  // Set color to be rendered to picking fbo (also used to check for selection highlight).\n  picking_setPickingColor(instancePickingColors);\n}\n";
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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