var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

// Copyright (c) 2015 - 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

import { COORDINATE_SYSTEM, Layer, experimental } from '../../core';
var log = experimental.log,
    fp64LowPart = experimental.fp64LowPart,
    enable64bitSupport = experimental.enable64bitSupport;

import { GL, Model, CylinderGeometry } from 'luma.gl';

import vs from './hexagon-cell-layer-vertex.glsl';
import vs64 from './hexagon-cell-layer-vertex-64.glsl';
import fs from './hexagon-cell-layer-fragment.glsl';

var DEFAULT_COLOR = [255, 0, 255, 255];

var defaultProps = {
  hexagonVertices: null,
  radius: null,
  angle: null,
  coverage: 1,
  elevationScale: 1,
  extruded: true,
  fp64: false,

  getCentroid: function getCentroid(x) {
    return x.centroid;
  },
  getColor: function getColor(x) {
    return x.color;
  },
  getElevation: function getElevation(x) {
    return x.elevation;
  },

  lightSettings: {
    lightsPosition: [-122.45, 37.75, 8000, -122.0, 38.0, 5000],
    ambientRatio: 0.4,
    diffuseRatio: 0.6,
    specularRatio: 0.8,
    lightsStrength: [1.2, 0.0, 0.8, 0.0],
    numberOfLights: 2
  }
};

var HexagonCellLayer = function (_Layer) {
  _inherits(HexagonCellLayer, _Layer);

  function HexagonCellLayer(props) {
    _classCallCheck(this, HexagonCellLayer);

    var missingProps = false;
    if (!props.hexagonVertices && (!props.radius || !Number.isFinite(props.angle))) {
      log.once(0, 'HexagonCellLayer: Either hexagonVertices or radius and angle are ' + 'needed to calculate primitive hexagon.');
      missingProps = true;
    } else if (props.hexagonVertices && (!Array.isArray(props.hexagonVertices) || props.hexagonVertices.length < 6)) {
      log.once(0, 'HexagonCellLayer: hexagonVertices needs to be an array of 6 points');

      missingProps = true;
    }

    if (missingProps) {
      log.once(0, 'Now using 1000 meter as default radius, 0 as default angle');
      props.radius = 1000;
      props.angle = 0;
    }

    return _possibleConstructorReturn(this, (HexagonCellLayer.__proto__ || Object.getPrototypeOf(HexagonCellLayer)).call(this, props));
  }

  _createClass(HexagonCellLayer, [{
    key: 'getShaders',
    value: function getShaders() {
      return enable64bitSupport(this.props) ? { vs: vs64, fs: fs, modules: ['project64', 'lighting', 'picking'] } : { vs: vs, fs: fs, modules: ['lighting', 'picking'] }; // 'project' module added by default.
    }

    /**
     * DeckGL calls initializeState when GL context is available
     * Essentially a deferred constructor
     */

  }, {
    key: 'initializeState',
    value: function initializeState() {
      var attributeManager = this.getAttributeManager();
      /* eslint-disable max-len */
      attributeManager.addInstanced({
        instancePositions: {
          size: 3,
          transition: true,
          accessor: ['getCentroid', 'getElevation'],
          update: this.calculateInstancePositions
        },
        instanceColors: {
          size: 4,
          type: GL.UNSIGNED_BYTE,
          transition: true,
          accessor: 'getColor',
          update: this.calculateInstanceColors
        }
      });
      /* eslint-enable max-len */
    }
  }, {
    key: 'updateAttribute',
    value: function updateAttribute(_ref) {
      var props = _ref.props,
          oldProps = _ref.oldProps,
          changeFlags = _ref.changeFlags;

      if (props.fp64 !== oldProps.fp64) {
        var attributeManager = this.getAttributeManager();
        attributeManager.invalidateAll();

        if (props.fp64 && props.coordinateSystem === COORDINATE_SYSTEM.LNGLAT) {
          attributeManager.addInstanced({
            instancePositions64xyLow: {
              size: 2,
              accessor: 'getCentroid',
              update: this.calculateInstancePositions64xyLow
            }
          });
        } else {
          attributeManager.remove(['instancePositions64xyLow']);
        }
      }
    }
  }, {
    key: 'updateState',
    value: function updateState(_ref2) {
      var props = _ref2.props,
          oldProps = _ref2.oldProps,
          changeFlags = _ref2.changeFlags;

      _get(HexagonCellLayer.prototype.__proto__ || Object.getPrototypeOf(HexagonCellLayer.prototype), 'updateState', this).call(this, { props: props, oldProps: oldProps, changeFlags: changeFlags });
      if (props.fp64 !== oldProps.fp64) {
        var gl = this.context.gl;

        if (this.state.model) {
          this.state.model.delete();
        }
        this.setState({ model: this._getModel(gl) });
      }
      this.updateAttribute({ props: props, oldProps: oldProps, changeFlags: changeFlags });

      this.updateUniforms();
    }
  }, {
    key: 'updateRadiusAngle',
    value: function updateRadiusAngle() {
      var angle = void 0;
      var radius = void 0;
      var hexagonVertices = this.props.hexagonVertices;


      if (Array.isArray(hexagonVertices) && hexagonVertices.length >= 6) {
        // calculate angle and vertices from hexagonVertices if provided
        var vertices = this.props.hexagonVertices;

        var vertex0 = vertices[0];
        var vertex3 = vertices[3];

        // transform to space coordinates
        var spaceCoord0 = this.projectFlat(vertex0);
        var spaceCoord3 = this.projectFlat(vertex3);

        // distance between two close centroids
        var dx = spaceCoord0[0] - spaceCoord3[0];
        var dy = spaceCoord0[1] - spaceCoord3[1];
        var dxy = Math.sqrt(dx * dx + dy * dy);

        // Calculate angle that the perpendicular hexagon vertex axis is tilted
        angle = Math.acos(dx / dxy) * -Math.sign(dy) + Math.PI / 2;
        radius = dxy / 2;
      } else if (this.props.radius && Number.isFinite(this.props.angle)) {
        // if no hexagonVertices provided, try use radius & angle
        var viewport = this.context.viewport;
        // TODO - this should be a standard uniform in project package

        var _viewport$getDistance = viewport.getDistanceScales(),
            pixelsPerMeter = _viewport$getDistance.pixelsPerMeter;

        angle = this.props.angle;
        radius = this.props.radius * pixelsPerMeter[0];
      }

      return { angle: angle, radius: radius };
    }
  }, {
    key: 'getCylinderGeometry',
    value: function getCylinderGeometry(radius) {
      return new CylinderGeometry({
        radius: radius,
        topRadius: radius,
        bottomRadius: radius,
        topCap: true,
        bottomCap: true,
        height: 1,
        nradial: 6,
        nvertical: 1
      });
    }
  }, {
    key: 'updateUniforms',
    value: function updateUniforms() {
      var _props = this.props,
          opacity = _props.opacity,
          elevationScale = _props.elevationScale,
          extruded = _props.extruded,
          coverage = _props.coverage,
          lightSettings = _props.lightSettings;
      var model = this.state.model;


      model.setUniforms(Object.assign({}, {
        extruded: extruded,
        opacity: opacity,
        coverage: coverage,
        elevationScale: elevationScale
      }, lightSettings));
    }
  }, {
    key: '_getModel',
    value: function _getModel(gl) {
      return new Model(gl, Object.assign({}, this.getShaders(), {
        id: this.props.id,
        geometry: this.getCylinderGeometry(1),
        isInstanced: true,
        shaderCache: this.context.shaderCache
      }));
    }
  }, {
    key: 'draw',
    value: function draw(_ref3) {
      var uniforms = _ref3.uniforms;

      _get(HexagonCellLayer.prototype.__proto__ || Object.getPrototypeOf(HexagonCellLayer.prototype), 'draw', this).call(this, { uniforms: Object.assign(this.updateRadiusAngle(), uniforms) });
    }
  }, {
    key: 'calculateInstancePositions',
    value: function calculateInstancePositions(attribute) {
      var _props2 = this.props,
          data = _props2.data,
          getCentroid = _props2.getCentroid,
          getElevation = _props2.getElevation;
      var value = attribute.value,
          size = attribute.size;

      var i = 0;
      var _iteratorNormalCompletion = true;
      var _didIteratorError = false;
      var _iteratorError = undefined;

      try {
        for (var _iterator = data[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
          var object = _step.value;

          var _getCentroid = getCentroid(object),
              _getCentroid2 = _slicedToArray(_getCentroid, 2),
              lon = _getCentroid2[0],
              lat = _getCentroid2[1];

          var elevation = getElevation(object);
          value[i + 0] = lon;
          value[i + 1] = lat;
          value[i + 2] = elevation || 0;
          i += size;
        }
      } catch (err) {
        _didIteratorError = true;
        _iteratorError = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion && _iterator.return) {
            _iterator.return();
          }
        } finally {
          if (_didIteratorError) {
            throw _iteratorError;
          }
        }
      }
    }
  }, {
    key: 'calculateInstancePositions64xyLow',
    value: function calculateInstancePositions64xyLow(attribute) {
      var _props3 = this.props,
          data = _props3.data,
          getCentroid = _props3.getCentroid;
      var value = attribute.value;

      var i = 0;
      var _iteratorNormalCompletion2 = true;
      var _didIteratorError2 = false;
      var _iteratorError2 = undefined;

      try {
        for (var _iterator2 = data[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
          var object = _step2.value;

          var position = getCentroid(object);
          value[i++] = fp64LowPart(position[0]);
          value[i++] = fp64LowPart(position[1]);
        }
      } catch (err) {
        _didIteratorError2 = true;
        _iteratorError2 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion2 && _iterator2.return) {
            _iterator2.return();
          }
        } finally {
          if (_didIteratorError2) {
            throw _iteratorError2;
          }
        }
      }
    }
  }, {
    key: 'calculateInstanceColors',
    value: function calculateInstanceColors(attribute) {
      var _props4 = this.props,
          data = _props4.data,
          getColor = _props4.getColor;
      var value = attribute.value,
          size = attribute.size;

      var i = 0;
      var _iteratorNormalCompletion3 = true;
      var _didIteratorError3 = false;
      var _iteratorError3 = undefined;

      try {
        for (var _iterator3 = data[Symbol.iterator](), _step3; !(_iteratorNormalCompletion3 = (_step3 = _iterator3.next()).done); _iteratorNormalCompletion3 = true) {
          var object = _step3.value;

          var color = getColor(object) || DEFAULT_COLOR;

          value[i + 0] = color[0];
          value[i + 1] = color[1];
          value[i + 2] = color[2];
          value[i + 3] = Number.isFinite(color[3]) ? color[3] : DEFAULT_COLOR[3];
          i += size;
        }
      } catch (err) {
        _didIteratorError3 = true;
        _iteratorError3 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion3 && _iterator3.return) {
            _iterator3.return();
          }
        } finally {
          if (_didIteratorError3) {
            throw _iteratorError3;
          }
        }
      }
    }
  }]);

  return HexagonCellLayer;
}(Layer);

export default HexagonCellLayer;


HexagonCellLayer.layerName = 'HexagonCellLayer';
HexagonCellLayer.defaultProps = defaultProps;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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