var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

// Copyright (c) 2015 - 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

import { CompositeLayer, experimental } from '../../core';
import HexagonCellLayer from '../hexagon-cell-layer/hexagon-cell-layer';

var log = experimental.log,
    BinSorter = experimental.BinSorter,
    getQuantizeScale = experimental.getQuantizeScale,
    getLinearScale = experimental.getLinearScale,
    defaultColorRange = experimental.defaultColorRange;


import { pointToHexbin } from './hexagon-aggregator';

function nop() {}

var defaultProps = {
  // color
  colorDomain: null,
  colorRange: defaultColorRange,
  getColorValue: function getColorValue(points) {
    return points.length;
  },
  lowerPercentile: 0,
  upperPercentile: 100,
  onSetColorDomain: nop,

  // elevation
  elevationDomain: null,
  elevationRange: [0, 1000],
  getElevationValue: function getElevationValue(points) {
    return points.length;
  },
  elevationLowerPercentile: 0,
  elevationUpperPercentile: 100,
  elevationScale: 1,
  onSetElevationDomain: nop,

  radius: 1000,
  coverage: 1,
  extruded: false,
  hexagonAggregator: pointToHexbin,
  getPosition: function getPosition(x) {
    return x.position;
  },
  fp64: false,
  // Optional settings for 'lighting' shader module
  lightSettings: {
    lightsPosition: [-122.45, 37.75, 8000, -122.0, 38.0, 5000],
    ambientRatio: 0.05,
    diffuseRatio: 0.6,
    specularRatio: 0.8,
    lightsStrength: [2.0, 0.0, 0.0, 0.0],
    numberOfLights: 2
  }
};

var HexagonLayer = function (_CompositeLayer) {
  _inherits(HexagonLayer, _CompositeLayer);

  function HexagonLayer(props) {
    _classCallCheck(this, HexagonLayer);

    if (!props.hexagonAggregator && !props.radius) {
      log.once(0, 'HexagonLayer: Default hexagonAggregator requires radius prop to be set, ' + 'Now using 1000 meter as default');

      props.radius = defaultProps.radius;
    }

    if (Number.isFinite(props.upperPercentile) && (props.upperPercentile > 100 || props.upperPercentile < 0)) {
      log.once(0, 'HexagonLayer: upperPercentile should be between 0 and 100. ' + 'Assign to 100 by default');

      props.upperPercentile = defaultProps.upperPercentile;
    }

    if (Number.isFinite(props.lowerPercentile) && (props.lowerPercentile > 100 || props.lowerPercentile < 0)) {
      log.once(0, 'HexagonLayer: lowerPercentile should be between 0 and 100. ' + 'Assign to 0 by default');

      props.lowerPercentile = defaultProps.upperPercentile;
    }

    if (props.lowerPercentile >= props.upperPercentile) {
      log.once(0, 'HexagonLayer: lowerPercentile should not be bigger than ' + 'upperPercentile. Assign to 0 by default');

      props.lowerPercentile = defaultProps.lowerPercentile;
    }

    return _possibleConstructorReturn(this, (HexagonLayer.__proto__ || Object.getPrototypeOf(HexagonLayer)).call(this, props));
  }

  _createClass(HexagonLayer, [{
    key: 'initializeState',
    value: function initializeState() {
      this.state = {
        hexagons: [],
        hexagonVertices: null,
        sortedColorBins: null,
        sortedElevationBins: null,
        colorValueDomain: null,
        elevationValueDomain: null,
        colorScaleFunc: nop,
        elevationScaleFunc: nop,
        dimensionUpdaters: this.getDimensionUpdaters()
      };
    }
  }, {
    key: 'updateState',
    value: function updateState(_ref) {
      var _this2 = this;

      var oldProps = _ref.oldProps,
          props = _ref.props,
          changeFlags = _ref.changeFlags;

      var dimensionChanges = this.getDimensionChanges(oldProps, props);

      if (changeFlags.dataChanged || this.needsReProjectPoints(oldProps, props)) {
        // project data into hexagons, and get sortedColorBins
        this.getHexagons();
      } else if (dimensionChanges) {
        dimensionChanges.forEach(function (f) {
          return typeof f === 'function' && f.apply(_this2);
        });
      }
    }
  }, {
    key: 'needsReProjectPoints',
    value: function needsReProjectPoints(oldProps, props) {
      return oldProps.radius !== props.radius || oldProps.hexagonAggregator !== props.hexagonAggregator;
    }
  }, {
    key: 'getDimensionUpdaters',
    value: function getDimensionUpdaters() {
      // dimension updaters are sequential,
      // if the first one needs to be called, the 2nd and 3rd one will automatically
      // be called. e.g. if ColorValue needs to be updated, getColorValueDomain and getColorScale
      // will automatically be called
      return {
        getColor: [{
          id: 'value',
          triggers: ['getColorValue'],
          updater: this.getSortedColorBins
        }, {
          id: 'domain',
          triggers: ['lowerPercentile', 'upperPercentile'],
          updater: this.getColorValueDomain
        }, {
          id: 'scaleFunc',
          triggers: ['colorDomain', 'colorRange'],
          updater: this.getColorScale
        }],
        getElevation: [{
          id: 'value',
          triggers: ['getElevationValue'],
          updater: this.getSortedElevationBins
        }, {
          id: 'domain',
          triggers: ['elevationLowerPercentile', 'elevationUpperPercentile'],
          updater: this.getElevationValueDomain
        }, {
          id: 'scaleFunc',
          triggers: ['elevationDomain', 'elevationRange'],
          updater: this.getElevationScale
        }]
      };
    }
  }, {
    key: 'getDimensionChanges',
    value: function getDimensionChanges(oldProps, props) {
      var dimensionUpdaters = this.state.dimensionUpdaters;

      var updaters = [];

      // get dimension to be updated
      for (var dimensionKey in dimensionUpdaters) {
        // return the first triggered updater for each dimension
        var needUpdate = dimensionUpdaters[dimensionKey].find(function (item) {
          return item.triggers.some(function (t) {
            return oldProps[t] !== props[t];
          });
        });

        if (needUpdate) {
          updaters.push(needUpdate.updater);
        }
      }

      return updaters.length ? updaters : null;
    }
  }, {
    key: 'getHexagons',
    value: function getHexagons() {
      var hexagonAggregator = this.props.hexagonAggregator;
      var viewport = this.context.viewport;

      var _hexagonAggregator = hexagonAggregator(this.props, viewport),
          hexagons = _hexagonAggregator.hexagons,
          hexagonVertices = _hexagonAggregator.hexagonVertices;

      this.setState({ hexagons: hexagons, hexagonVertices: hexagonVertices });
      this.getSortedBins();
    }
  }, {
    key: 'getPickingInfo',
    value: function getPickingInfo(_ref2) {
      var info = _ref2.info;
      var _state = this.state,
          sortedColorBins = _state.sortedColorBins,
          sortedElevationBins = _state.sortedElevationBins;

      var isPicked = info.picked && info.index > -1;

      var object = null;
      if (isPicked) {
        var cell = this.state.hexagons[info.index];

        var colorValue = sortedColorBins.binMap[cell.index] && sortedColorBins.binMap[cell.index].value;
        var elevationValue = sortedElevationBins.binMap[cell.index] && sortedElevationBins.binMap[cell.index].value;

        object = Object.assign({
          colorValue: colorValue,
          elevationValue: elevationValue
        }, cell);
      }

      // add bin colorValue and elevationValue to info
      return Object.assign(info, {
        picked: Boolean(object),
        // override object with picked cell
        object: object
      });
    }
  }, {
    key: 'getUpdateTriggers',
    value: function getUpdateTriggers() {
      var _this3 = this;

      var dimensionUpdaters = this.state.dimensionUpdaters;

      // merge all dimension triggers

      var updateTriggers = {};

      var _loop = function _loop(dimensionKey) {
        updateTriggers[dimensionKey] = {};

        var _iteratorNormalCompletion = true;
        var _didIteratorError = false;
        var _iteratorError = undefined;

        try {
          for (var _iterator = dimensionUpdaters[dimensionKey][Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
            var step = _step.value;

            step.triggers.forEach(function (prop) {
              updateTriggers[dimensionKey][prop] = _this3.props[prop];
            });
          }
        } catch (err) {
          _didIteratorError = true;
          _iteratorError = err;
        } finally {
          try {
            if (!_iteratorNormalCompletion && _iterator.return) {
              _iterator.return();
            }
          } finally {
            if (_didIteratorError) {
              throw _iteratorError;
            }
          }
        }
      };

      for (var dimensionKey in dimensionUpdaters) {
        _loop(dimensionKey);
      }

      return updateTriggers;
    }
  }, {
    key: 'getValueDomain',
    value: function getValueDomain() {
      this.getColorValueDomain();
      this.getElevationValueDomain();
    }
  }, {
    key: 'getSortedBins',
    value: function getSortedBins() {
      this.getSortedColorBins();
      this.getSortedElevationBins();
    }
  }, {
    key: 'getSortedColorBins',
    value: function getSortedColorBins() {
      var getColorValue = this.props.getColorValue;

      var sortedColorBins = new BinSorter(this.state.hexagons || [], getColorValue);

      this.setState({ sortedColorBins: sortedColorBins });
      this.getColorValueDomain();
    }
  }, {
    key: 'getSortedElevationBins',
    value: function getSortedElevationBins() {
      var getElevationValue = this.props.getElevationValue;

      var sortedElevationBins = new BinSorter(this.state.hexagons || [], getElevationValue);
      this.setState({ sortedElevationBins: sortedElevationBins });
      this.getElevationValueDomain();
    }
  }, {
    key: 'getColorValueDomain',
    value: function getColorValueDomain() {
      var _props = this.props,
          lowerPercentile = _props.lowerPercentile,
          upperPercentile = _props.upperPercentile,
          onSetColorDomain = _props.onSetColorDomain;


      this.state.colorValueDomain = this.state.sortedColorBins.getValueRange([lowerPercentile, upperPercentile]);

      if (typeof onSetColorDomain === 'function') {
        onSetColorDomain(this.state.colorValueDomain);
      }

      this.getColorScale();
    }
  }, {
    key: 'getElevationValueDomain',
    value: function getElevationValueDomain() {
      var _props2 = this.props,
          elevationLowerPercentile = _props2.elevationLowerPercentile,
          elevationUpperPercentile = _props2.elevationUpperPercentile,
          onSetElevationDomain = _props2.onSetElevationDomain;


      this.state.elevationValueDomain = this.state.sortedElevationBins.getValueRange([elevationLowerPercentile, elevationUpperPercentile]);

      if (typeof onSetElevationDomain === 'function') {
        onSetElevationDomain(this.state.elevationValueDomain);
      }

      this.getElevationScale();
    }
  }, {
    key: 'getColorScale',
    value: function getColorScale() {
      var colorRange = this.props.colorRange;

      var colorDomain = this.props.colorDomain || this.state.colorValueDomain;

      this.state.colorScaleFunc = getQuantizeScale(colorDomain, colorRange);
    }
  }, {
    key: 'getElevationScale',
    value: function getElevationScale() {
      var elevationRange = this.props.elevationRange;

      var elevationDomain = this.props.elevationDomain || this.state.elevationValueDomain;

      this.state.elevationScaleFunc = getLinearScale(elevationDomain, elevationRange);
    }
  }, {
    key: '_onGetSublayerColor',
    value: function _onGetSublayerColor(cell) {
      var _state2 = this.state,
          sortedColorBins = _state2.sortedColorBins,
          colorScaleFunc = _state2.colorScaleFunc,
          colorValueDomain = _state2.colorValueDomain;


      var cv = sortedColorBins.binMap[cell.index] && sortedColorBins.binMap[cell.index].value;
      var colorDomain = this.props.colorDomain || colorValueDomain;

      var isColorValueInDomain = cv >= colorDomain[0] && cv <= colorDomain[colorDomain.length - 1];

      // if cell value is outside domain, set alpha to 0
      var color = isColorValueInDomain ? colorScaleFunc(cv) : [0, 0, 0, 0];

      // add alpha to color if not defined in colorRange
      color[3] = Number.isFinite(color[3]) ? color[3] : 255;

      return color;
    }
  }, {
    key: '_onGetSublayerElevation',
    value: function _onGetSublayerElevation(cell) {
      var _state3 = this.state,
          sortedElevationBins = _state3.sortedElevationBins,
          elevationScaleFunc = _state3.elevationScaleFunc,
          elevationValueDomain = _state3.elevationValueDomain;

      var ev = sortedElevationBins.binMap[cell.index] && sortedElevationBins.binMap[cell.index].value;

      var elevationDomain = this.props.elevationDomain || elevationValueDomain;

      var isElevationValueInDomain = ev >= elevationDomain[0] && ev <= elevationDomain[elevationDomain.length - 1];

      // if cell value is outside domain, set elevation to -1
      return isElevationValueInDomain ? elevationScaleFunc(ev) : -1;
    }

    // for subclassing, override this method to return
    // customized sub layer props

  }, {
    key: 'getSubLayerProps',
    value: function getSubLayerProps() {
      var _props3 = this.props,
          radius = _props3.radius,
          elevationScale = _props3.elevationScale,
          extruded = _props3.extruded,
          coverage = _props3.coverage,
          lightSettings = _props3.lightSettings,
          fp64 = _props3.fp64;

      // return props to the sublayer constructor

      return _get(HexagonLayer.prototype.__proto__ || Object.getPrototypeOf(HexagonLayer.prototype), 'getSubLayerProps', this).call(this, {
        id: 'hexagon-cell',
        data: this.state.hexagons,

        fp64: fp64,
        hexagonVertices: this.state.hexagonVertices,
        radius: radius,
        elevationScale: elevationScale,
        angle: Math.PI,
        extruded: extruded,
        coverage: coverage,
        lightSettings: lightSettings,

        getColor: this._onGetSublayerColor.bind(this),
        getElevation: this._onGetSublayerElevation.bind(this),
        updateTriggers: this.getUpdateTriggers()
      });
    }

    // for subclassing, override this method to return
    // customized sub layer class

  }, {
    key: 'getSubLayerClass',
    value: function getSubLayerClass() {
      return HexagonCellLayer;
    }
  }, {
    key: 'renderLayers',
    value: function renderLayers() {
      var SubLayerClass = this.getSubLayerClass();

      return new SubLayerClass(this.getSubLayerProps());
    }
  }]);

  return HexagonLayer;
}(CompositeLayer);

export default HexagonLayer;


HexagonLayer.layerName = 'HexagonLayer';
HexagonLayer.defaultProps = defaultProps;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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