// Copyright (c) 2015 - 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

export default "#define SHADER_NAME path-layer-fragment-shader\n\n#ifdef GL_ES\nprecision highp float;\n#endif\n\nuniform float jointType;\nuniform float miterLimit;\nuniform float alignMode;\n\nvarying vec4 vColor;\nvarying vec2 vCornerOffset;\nvarying float vMiterLength;\nvarying vec2 vDashArray;\nvarying float vPathPosition;\nvarying float vPathLength;\n\n// mod doesn't work correctly for negative numbers\nfloat mod2(float a, float b) {\n  return a - floor(a / b) * b;\n}\n\nfloat round(float x) {\n  return floor(x + 0.5);\n}\n\n// if given position is in the gap part of the dashed line\n// dashArray.x: solid stroke length, relative to width\n// dashArray.y: gap length, relative to width\n// alignMode:\n// 0 - no adjustment\n// o----     ----     ----     ---- o----     -o----     ----     o\n// 1 - stretch to fit, draw half dash at each end for nicer joints\n// o--    ----    ----    ----    --o--      --o--     ----     --o\nbool dash_isFragInGap() {\n  float solidLength = vDashArray.x;\n  float gapLength = vDashArray.y;\n\n  float unitLength = solidLength + gapLength;\n\n  if (unitLength == 0.0) {\n    return false;\n  }\n\n  unitLength = mix(\n    unitLength,\n    vPathLength / round(vPathLength / unitLength),\n    alignMode\n  );\n\n  float offset = alignMode * solidLength / 2.0;\n\n  return gapLength > 0.0 &&\n    vPathPosition >= 0.0 &&\n    vPathPosition <= vPathLength &&\n    mod2(vPathPosition + offset, unitLength) > solidLength;\n}\n\nvoid main(void) {\n  // if joint is rounded, test distance from the corner\n  if (jointType > 0.0 && vMiterLength > 0.0 && length(vCornerOffset) > 1.0) {\n    // Enable to debug joints\n    // gl_FragColor = vec4(0., 1., 0., 1.);\n    // return;\n    discard;\n  }\n  if (jointType == 0.0 && vMiterLength > miterLimit) {\n    // Enable to debug joints\n    // gl_FragColor = vec4(0., 0., 1., 1.);\n    // return;\n    discard;\n  }\n  if (vColor.a == 0.0 || dash_isFragInGap()) {\n    // Enable to debug joints\n    // gl_FragColor = vec4(0., 1., 1., 1.);\n    // return;\n    discard;\n  }\n  gl_FragColor = vColor;\n\n  // use highlight color if this fragment belongs to the selected object.\n  gl_FragColor = picking_filterHighlightColor(gl_FragColor);\n\n  // use picking color if rendering to picking FBO.\n  gl_FragColor = picking_filterPickingColor(gl_FragColor);\n}\n";
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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