var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

// Copyright (c) 2015 - 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

import { COORDINATE_SYSTEM, Layer, experimental } from '../../core';
var fp64LowPart = experimental.fp64LowPart,
    enable64bitSupport = experimental.enable64bitSupport;

import { GL, Model, Geometry } from 'luma.gl';

import vs from './path-layer-vertex.glsl';
import vs64 from './path-layer-vertex-64.glsl';
import fs from './path-layer-fragment.glsl';

var DEFAULT_COLOR = [0, 0, 0, 255];

var defaultProps = {
  widthScale: 1, // stroke width in meters
  widthMinPixels: 0, //  min stroke width in pixels
  widthMaxPixels: Number.MAX_SAFE_INTEGER, // max stroke width in pixels
  rounded: false,
  miterLimit: 4,
  fp64: false,
  dashJustified: false,

  getPath: function getPath(object) {
    return object.path;
  },
  getColor: function getColor(object) {
    return object.color || DEFAULT_COLOR;
  },
  getWidth: function getWidth(object) {
    return object.width || 1;
  },
  getDashArray: null
};

var isClosed = function isClosed(path) {
  var firstPoint = path[0];
  var lastPoint = path[path.length - 1];
  return firstPoint[0] === lastPoint[0] && firstPoint[1] === lastPoint[1] && firstPoint[2] === lastPoint[2];
};

var PathLayer = function (_Layer) {
  _inherits(PathLayer, _Layer);

  function PathLayer() {
    _classCallCheck(this, PathLayer);

    return _possibleConstructorReturn(this, (PathLayer.__proto__ || Object.getPrototypeOf(PathLayer)).apply(this, arguments));
  }

  _createClass(PathLayer, [{
    key: 'getShaders',
    value: function getShaders() {
      return enable64bitSupport(this.props) ? { vs: vs64, fs: fs, modules: ['project64', 'picking'] } : { vs: vs, fs: fs, modules: ['picking'] }; // 'project' module added by default.
    }
  }, {
    key: 'initializeState',
    value: function initializeState() {
      var attributeManager = this.getAttributeManager();
      /* eslint-disable max-len */
      attributeManager.addInstanced({
        instanceStartPositions: { size: 3, update: this.calculateStartPositions },
        instanceEndPositions: { size: 3, update: this.calculateEndPositions },
        instanceLeftDeltas: { size: 3, update: this.calculateLeftDeltas },
        instanceRightDeltas: { size: 3, update: this.calculateRightDeltas },
        instanceStrokeWidths: { size: 1, accessor: 'getWidth', update: this.calculateStrokeWidths },
        instanceDashArrays: { size: 2, accessor: 'getDashArray', update: this.calculateDashArrays },
        instanceColors: {
          size: 4,
          type: GL.UNSIGNED_BYTE,
          accessor: 'getColor',
          update: this.calculateColors
        },
        instancePickingColors: { size: 3, type: GL.UNSIGNED_BYTE, update: this.calculatePickingColors }
      });
      /* eslint-enable max-len */
    }
  }, {
    key: 'updateAttribute',
    value: function updateAttribute(_ref) {
      var props = _ref.props,
          oldProps = _ref.oldProps,
          changeFlags = _ref.changeFlags;

      if (props.fp64 !== oldProps.fp64) {
        var attributeManager = this.getAttributeManager();
        attributeManager.invalidateAll();

        if (props.fp64 && props.coordinateSystem === COORDINATE_SYSTEM.LNGLAT) {
          attributeManager.addInstanced({
            instanceStartEndPositions64xyLow: {
              size: 4,
              update: this.calculateInstanceStartEndPositions64xyLow
            }
          });
        } else {
          attributeManager.remove(['instanceStartEndPositions64xyLow']);
        }
      }
    }
  }, {
    key: 'updateState',
    value: function updateState(_ref2) {
      var oldProps = _ref2.oldProps,
          props = _ref2.props,
          changeFlags = _ref2.changeFlags;

      _get(PathLayer.prototype.__proto__ || Object.getPrototypeOf(PathLayer.prototype), 'updateState', this).call(this, { props: props, oldProps: oldProps, changeFlags: changeFlags });

      var getPath = this.props.getPath;

      var attributeManager = this.getAttributeManager();
      if (props.fp64 !== oldProps.fp64) {
        var gl = this.context.gl;

        if (this.state.model) {
          this.state.model.delete();
        }
        this.setState({ model: this._getModel(gl) });
      }
      this.updateAttribute({ props: props, oldProps: oldProps, changeFlags: changeFlags });

      var geometryChanged = changeFlags.dataChanged || changeFlags.updateTriggersChanged && (changeFlags.updateTriggersChanged.all || changeFlags.updateTriggersChanged.getPath);

      if (geometryChanged) {
        // this.state.paths only stores point positions in each path
        var paths = props.data.map(getPath);
        var numInstances = paths.reduce(function (count, path) {
          return count + path.length - 1;
        }, 0);

        this.setState({ paths: paths, numInstances: numInstances });
        attributeManager.invalidateAll();
      }
    }
  }, {
    key: 'draw',
    value: function draw(_ref3) {
      var uniforms = _ref3.uniforms;
      var _props = this.props,
          rounded = _props.rounded,
          miterLimit = _props.miterLimit,
          widthScale = _props.widthScale,
          widthMinPixels = _props.widthMinPixels,
          widthMaxPixels = _props.widthMaxPixels,
          dashJustified = _props.dashJustified;


      this.state.model.render(Object.assign({}, uniforms, {
        jointType: Number(rounded),
        alignMode: Number(dashJustified),
        widthScale: widthScale,
        miterLimit: miterLimit,
        widthMinPixels: widthMinPixels,
        widthMaxPixels: widthMaxPixels
      }));
    }
  }, {
    key: '_getModel',
    value: function _getModel(gl) {
      /*
       *       _
       *        "-_ 1                   3                       5
       *     _     "o---------------------o-------------------_-o
       *       -   / ""--..__              '.             _.-' /
       *   _     "@- - - - - ""--..__- - - - x - - - -_.@'    /
       *    "-_  /                   ""--..__ '.  _,-` :     /
       *       "o----------------------------""-o'    :     /
       *      0,2                            4 / '.  :     /
       *                                      /   '.:     /
       *                                     /     :'.   /
       *                                    /     :  ', /
       *                                   /     :     o
       */

      var SEGMENT_INDICES = [
      // start corner
      0, 2, 1,
      // body
      1, 2, 4, 1, 4, 3,
      // end corner
      3, 4, 5];

      // [0] position on segment - 0: start, 1: end
      // [1] side of path - -1: left, 0: center, 1: right
      // [2] role - 0: offset point 1: joint point
      var SEGMENT_POSITIONS = [
      // bevel start corner
      0, 0, 1,
      // start inner corner
      0, -1, 0,
      // start outer corner
      0, 1, 0,
      // end inner corner
      1, -1, 0,
      // end outer corner
      1, 1, 0,
      // bevel end corner
      1, 0, 1];

      return new Model(gl, Object.assign({}, this.getShaders(), {
        id: this.props.id,
        geometry: new Geometry({
          drawMode: GL.TRIANGLES,
          attributes: {
            indices: new Uint16Array(SEGMENT_INDICES),
            positions: new Float32Array(SEGMENT_POSITIONS)
          }
        }),
        isInstanced: true,
        shaderCache: this.context.shaderCache
      }));
    }
  }, {
    key: 'calculateStartPositions',
    value: function calculateStartPositions(attribute) {
      var paths = this.state.paths;
      var value = attribute.value;


      var i = 0;
      paths.forEach(function (path) {
        var numSegments = path.length - 1;
        for (var ptIndex = 0; ptIndex < numSegments; ptIndex++) {
          var point = path[ptIndex];
          value[i++] = point[0];
          value[i++] = point[1];
          value[i++] = point[2] || 0;
        }
      });
    }
  }, {
    key: 'calculateEndPositions',
    value: function calculateEndPositions(attribute) {
      var paths = this.state.paths;
      var value = attribute.value;


      var i = 0;
      paths.forEach(function (path) {
        for (var ptIndex = 1; ptIndex < path.length; ptIndex++) {
          var point = path[ptIndex];
          value[i++] = point[0];
          value[i++] = point[1];
          value[i++] = point[2] || 0;
        }
      });
    }
  }, {
    key: 'calculateInstanceStartEndPositions64xyLow',
    value: function calculateInstanceStartEndPositions64xyLow(attribute) {
      var paths = this.state.paths;
      var value = attribute.value;


      var i = 0;
      paths.forEach(function (path) {
        var numSegments = path.length - 1;
        for (var ptIndex = 0; ptIndex < numSegments; ptIndex++) {
          var startPoint = path[ptIndex];
          var endPoint = path[ptIndex + 1];
          value[i++] = fp64LowPart(startPoint[0]);
          value[i++] = fp64LowPart(startPoint[1]);
          value[i++] = fp64LowPart(endPoint[0]);
          value[i++] = fp64LowPart(endPoint[1]);
        }
      });
    }
  }, {
    key: 'calculateLeftDeltas',
    value: function calculateLeftDeltas(attribute) {
      var paths = this.state.paths;
      var value = attribute.value;


      var i = 0;
      paths.forEach(function (path) {
        var numSegments = path.length - 1;
        var prevPoint = isClosed(path) ? path[path.length - 2] : path[0];

        for (var ptIndex = 0; ptIndex < numSegments; ptIndex++) {
          var point = path[ptIndex];
          value[i++] = point[0] - prevPoint[0];
          value[i++] = point[1] - prevPoint[1];
          value[i++] = point[2] - prevPoint[2] || 0;
          prevPoint = point;
        }
      });
    }
  }, {
    key: 'calculateRightDeltas',
    value: function calculateRightDeltas(attribute) {
      var paths = this.state.paths;
      var value = attribute.value;


      var i = 0;
      paths.forEach(function (path) {
        for (var ptIndex = 1; ptIndex < path.length; ptIndex++) {
          var point = path[ptIndex];
          var nextPoint = path[ptIndex + 1];
          if (!nextPoint) {
            nextPoint = isClosed(path) ? path[1] : point;
          }

          value[i++] = nextPoint[0] - point[0];
          value[i++] = nextPoint[1] - point[1];
          value[i++] = nextPoint[2] - point[2] || 0;
        }
      });
    }
  }, {
    key: 'calculateStrokeWidths',
    value: function calculateStrokeWidths(attribute) {
      var _props2 = this.props,
          data = _props2.data,
          getWidth = _props2.getWidth;
      var paths = this.state.paths;
      var value = attribute.value;


      var i = 0;
      paths.forEach(function (path, index) {
        var width = getWidth(data[index], index);
        for (var ptIndex = 1; ptIndex < path.length; ptIndex++) {
          value[i++] = width;
        }
      });
    }
  }, {
    key: 'calculateDashArrays',
    value: function calculateDashArrays(attribute) {
      var _props3 = this.props,
          data = _props3.data,
          getDashArray = _props3.getDashArray;

      if (!getDashArray) {
        return;
      }

      var paths = this.state.paths;
      var value = attribute.value;

      var i = 0;
      paths.forEach(function (path, index) {
        var dashArray = getDashArray(data[index], index);
        for (var ptIndex = 1; ptIndex < path.length; ptIndex++) {
          value[i++] = dashArray[0];
          value[i++] = dashArray[1];
        }
      });
    }
  }, {
    key: 'calculateColors',
    value: function calculateColors(attribute) {
      var _props4 = this.props,
          data = _props4.data,
          getColor = _props4.getColor;
      var paths = this.state.paths;
      var value = attribute.value;


      var i = 0;
      paths.forEach(function (path, index) {
        var pointColor = getColor(data[index], index);
        if (isNaN(pointColor[3])) {
          pointColor[3] = 255;
        }
        for (var ptIndex = 1; ptIndex < path.length; ptIndex++) {
          value[i++] = pointColor[0];
          value[i++] = pointColor[1];
          value[i++] = pointColor[2];
          value[i++] = pointColor[3];
        }
      });
    }

    // Override the default picking colors calculation

  }, {
    key: 'calculatePickingColors',
    value: function calculatePickingColors(attribute) {
      var _this2 = this;

      var paths = this.state.paths;
      var value = attribute.value;


      var i = 0;
      paths.forEach(function (path, index) {
        var pickingColor = _this2.encodePickingColor(index);
        for (var ptIndex = 1; ptIndex < path.length; ptIndex++) {
          value[i++] = pickingColor[0];
          value[i++] = pickingColor[1];
          value[i++] = pickingColor[2];
        }
      });
    }
  }]);

  return PathLayer;
}(Layer);

export default PathLayer;


PathLayer.layerName = 'PathLayer';
PathLayer.defaultProps = defaultProps;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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