var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

// Copyright (c) 2015 - 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

import { CompositeLayer, experimental } from '../../core';
var get = experimental.get;

import SolidPolygonLayer from '../solid-polygon-layer/solid-polygon-layer';
import PathLayer from '../path-layer/path-layer';
import * as Polygon from '../solid-polygon-layer/polygon';

var defaultLineColor = [0x0, 0x0, 0x0, 0xff];
var defaultFillColor = [0x0, 0x0, 0x0, 0xff];

var defaultProps = {
  stroked: true,
  filled: true,
  extruded: false,
  elevationScale: 1,
  wireframe: false,

  lineWidthScale: 1,
  lineWidthMinPixels: 0,
  lineWidthMaxPixels: Number.MAX_SAFE_INTEGER,
  lineJointRounded: false,
  lineMiterLimit: 4,
  lineDashJustified: false,
  fp64: false,

  getPolygon: function getPolygon(f) {
    return get(f, 'polygon');
  },
  // Polygon fill color
  getFillColor: function getFillColor(f) {
    return get(f, 'fillColor') || defaultFillColor;
  },
  // Point, line and polygon outline color
  getLineColor: function getLineColor(f) {
    return get(f, 'lineColor') || defaultLineColor;
  },
  // Line and polygon outline accessors
  getLineWidth: function getLineWidth(f) {
    return get(f, 'lineWidth') || 1;
  },
  // Line dash array accessor
  getLineDashArray: null,
  // Polygon extrusion accessor
  getElevation: function getElevation(f) {
    return get(f, 'elevation') || 1000;
  },

  // Optional settings for 'lighting' shader module
  lightSettings: {
    lightsPosition: [-122.45, 37.75, 8000, -122.0, 38.0, 5000],
    ambientRatio: 0.05,
    diffuseRatio: 0.6,
    specularRatio: 0.8,
    lightsStrength: [2.0, 0.0, 0.0, 0.0],
    numberOfLights: 2
  }
};

var PolygonLayer = function (_CompositeLayer) {
  _inherits(PolygonLayer, _CompositeLayer);

  function PolygonLayer() {
    _classCallCheck(this, PolygonLayer);

    return _possibleConstructorReturn(this, (PolygonLayer.__proto__ || Object.getPrototypeOf(PolygonLayer)).apply(this, arguments));
  }

  _createClass(PolygonLayer, [{
    key: 'initializeState',
    value: function initializeState() {
      this.state = {
        paths: []
      };
    }
  }, {
    key: 'updateState',
    value: function updateState(_ref) {
      var _this2 = this;

      var oldProps = _ref.oldProps,
          props = _ref.props,
          changeFlags = _ref.changeFlags;

      var geometryChanged = changeFlags.dataChanged || changeFlags.updateTriggersChanged && (changeFlags.updateTriggersChanged.all || changeFlags.updateTriggersChanged.getPolygon);

      if (geometryChanged) {
        var _props = this.props,
            data = _props.data,
            getPolygon = _props.getPolygon;

        this.state.paths = [];
        data.forEach(function (object) {
          var complexPolygon = Polygon.normalize(getPolygon(object));
          complexPolygon.forEach(function (polygon) {
            return _this2.state.paths.push({
              path: polygon,
              object: object
            });
          });
        });
      }
    }
  }, {
    key: 'getPickingInfo',
    value: function getPickingInfo(_ref2) {
      var info = _ref2.info;

      return Object.assign(info, {
        // override object with picked data
        object: info.object && info.object.object || info.object
      });
    }

    /* eslint-disable complexity */

  }, {
    key: 'renderLayers',
    value: function renderLayers() {
      // Layer composition props
      var _props2 = this.props,
          data = _props2.data,
          stroked = _props2.stroked,
          filled = _props2.filled,
          extruded = _props2.extruded,
          wireframe = _props2.wireframe,
          elevationScale = _props2.elevationScale;

      // Rendering props underlying layer

      var _props3 = this.props,
          lineWidthScale = _props3.lineWidthScale,
          lineWidthMinPixels = _props3.lineWidthMinPixels,
          lineWidthMaxPixels = _props3.lineWidthMaxPixels,
          lineJointRounded = _props3.lineJointRounded,
          lineMiterLimit = _props3.lineMiterLimit,
          lineDashJustified = _props3.lineDashJustified,
          fp64 = _props3.fp64;

      // Accessor props for underlying layers

      var _props4 = this.props,
          getFillColor = _props4.getFillColor,
          getLineColor = _props4.getLineColor,
          getLineWidth = _props4.getLineWidth,
          getLineDashArray = _props4.getLineDashArray,
          getElevation = _props4.getElevation,
          getPolygon = _props4.getPolygon,
          updateTriggers = _props4.updateTriggers,
          lightSettings = _props4.lightSettings;
      var paths = this.state.paths;


      var hasData = data && data.length > 0;

      // Filled Polygon Layer
      var polygonLayer = filled && hasData && new SolidPolygonLayer(this.getSubLayerProps({
        id: 'fill',
        updateTriggers: {
          getElevation: updateTriggers.getElevation,
          getColor: updateTriggers.getFillColor
        }
      }), {
        data: data,
        extruded: extruded,
        elevationScale: elevationScale,

        fp64: fp64,
        wireframe: false,

        getPolygon: getPolygon,
        getElevation: getElevation,
        getColor: getFillColor,

        lightSettings: lightSettings
      });

      var polygonWireframeLayer = extruded && wireframe && hasData && new SolidPolygonLayer(this.getSubLayerProps({
        id: 'wireframe',
        updateTriggers: {
          getElevation: updateTriggers.getElevation,
          getColor: updateTriggers.getLineColor
        }
      }), {
        data: data,

        fp64: fp64,
        extruded: true,
        elevationScale: elevationScale,
        wireframe: true,

        getPolygon: getPolygon,
        getElevation: getElevation,
        getColor: getLineColor
      });

      // Polygon line layer
      var polygonLineLayer = !extruded && stroked && hasData && new PathLayer(this.getSubLayerProps({
        id: 'stroke',
        updateTriggers: {
          getWidth: updateTriggers.getLineWidth,
          getColor: updateTriggers.getLineColor,
          getDashArray: updateTriggers.getLineDashArray
        }
      }), {
        data: paths,

        fp64: fp64,
        widthScale: lineWidthScale,
        widthMinPixels: lineWidthMinPixels,
        widthMaxPixels: lineWidthMaxPixels,
        rounded: lineJointRounded,
        miterLimit: lineMiterLimit,
        dashJustified: lineDashJustified,

        getPath: function getPath(x) {
          return x.path;
        },
        getColor: function getColor(x) {
          return getLineColor(x.object);
        },
        getWidth: function getWidth(x) {
          return getLineWidth(x.object);
        },
        getDashArray: getLineDashArray && function (x) {
          return getLineDashArray(x.object);
        }
      });

      return [
      // If not extruded: flat fill layer is drawn below outlines
      !extruded && polygonLayer, polygonWireframeLayer, polygonLineLayer,
      // If extruded: draw fill layer last for correct blending behavior
      extruded && polygonLayer];
    }
    /* eslint-enable complexity */

  }]);

  return PolygonLayer;
}(CompositeLayer);

export default PolygonLayer;


PolygonLayer.layerName = 'PolygonLayer';
PolygonLayer.defaultProps = defaultProps;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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