// Copyright (c) 2015 - 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

export default "#define SHADER_NAME scatterplot-layer-vertex-shader\n\nattribute vec3 positions;\n\nattribute vec3 instancePositions;\nattribute float instanceRadius;\nattribute vec4 instanceColors;\nattribute vec3 instancePickingColors;\n\nuniform float opacity;\nuniform float radiusScale;\nuniform float radiusMinPixels;\nuniform float radiusMaxPixels;\nuniform float outline;\nuniform float strokeWidth;\n\nvarying vec4 vColor;\nvarying vec2 unitPosition;\nvarying float innerUnitRadius;\n\nvoid main(void) {\n  // Multiply out radius and clamp to limits\n  float outerRadiusPixels = clamp(\n    project_scale(radiusScale * instanceRadius),\n    radiusMinPixels, radiusMaxPixels\n  );\n  // outline is centered at the radius\n  // outer radius needs to offset by half stroke width\n  outerRadiusPixels += outline * strokeWidth / 2.0;\n\n  // position on the containing square in [-1, 1] space\n  unitPosition = positions.xy;\n  // 0 - solid circle, 1 - stroke with lineWidth=0\n  innerUnitRadius = outline * (1.0 - strokeWidth / outerRadiusPixels);\n\n  // Find the center of the point and add the current vertex\n  vec3 center = project_position(instancePositions);\n  vec3 vertex = positions * outerRadiusPixels;\n  gl_Position = project_to_clipspace(vec4(center + vertex, 1.0));\n\n  // Apply opacity to instance color, or return instance picking color\n  vColor = vec4(instanceColors.rgb, instanceColors.a * opacity) / 255.;\n\n  // Set color to be rendered to picking fbo (also used to check for selection highlight).\n  picking_setPickingColor(instancePickingColors);\n}\n";
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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