var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

// Copyright (c) 2015 - 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

import { COORDINATE_SYSTEM, Layer, experimental } from '../../core';
var enable64bitSupport = experimental.enable64bitSupport,
    get = experimental.get;

import { GL, Model, Geometry } from 'luma.gl';
import { compareProps } from '../../core/lifecycle/props';

// Polygon geometry generation is managed by the polygon tesselator
import { PolygonTesselator } from './polygon-tesselator';
import { PolygonTesselatorExtruded } from './polygon-tesselator-extruded';

import vs from './solid-polygon-layer-vertex.glsl';
import vs64 from './solid-polygon-layer-vertex-64.glsl';
import fs from './solid-polygon-layer-fragment.glsl';

var defaultProps = {
  // Whether to extrude
  extruded: false,
  // Whether to draw a GL.LINES wireframe of the polygon
  wireframe: false,
  fp64: false,

  // elevation multiplier
  elevationScale: 1,

  // Accessor for polygon geometry
  getPolygon: function getPolygon(f) {
    return get(f, 'polygon') || get(f, 'geometry.coordinates');
  },
  // Accessor for extrusion height
  getElevation: function getElevation(f) {
    return get(f, 'elevation') || get(f, 'properties.height') || 0;
  },
  // Accessor for color
  getColor: function getColor(f) {
    return get(f, 'color') || get(f, 'properties.color');
  },

  // Optional settings for 'lighting' shader module
  lightSettings: {
    lightsPosition: [-122.45, 37.75, 8000, -122.0, 38.0, 5000],
    ambientRatio: 0.05,
    diffuseRatio: 0.6,
    specularRatio: 0.8,
    lightsStrength: [2.0, 0.0, 0.0, 0.0],
    numberOfLights: 2
  }
};

var SolidPolygonLayer = function (_Layer) {
  _inherits(SolidPolygonLayer, _Layer);

  function SolidPolygonLayer() {
    _classCallCheck(this, SolidPolygonLayer);

    return _possibleConstructorReturn(this, (SolidPolygonLayer.__proto__ || Object.getPrototypeOf(SolidPolygonLayer)).apply(this, arguments));
  }

  _createClass(SolidPolygonLayer, [{
    key: 'getShaders',
    value: function getShaders() {
      return enable64bitSupport(this.props) ? { vs: vs64, fs: fs, modules: ['project64', 'lighting', 'picking'] } : { vs: vs, fs: fs, modules: ['lighting', 'picking'] }; // 'project' module added by default.
    }
  }, {
    key: 'initializeState',
    value: function initializeState() {
      var gl = this.context.gl;

      this.setState({
        numInstances: 0,
        IndexType: gl.getExtension('OES_element_index_uint') ? Uint32Array : Uint16Array
      });

      var attributeManager = this.getAttributeManager();
      var noAlloc = true;
      /* eslint-disable max-len */
      attributeManager.add({
        indices: { size: 1, isIndexed: true, update: this.calculateIndices, noAlloc: noAlloc },
        positions: { size: 3, accessor: 'getElevation', update: this.calculatePositions, noAlloc: noAlloc },
        normals: { size: 3, update: this.calculateNormals, noAlloc: noAlloc },
        colors: {
          size: 4,
          type: GL.UNSIGNED_BYTE,
          accessor: 'getColor',
          update: this.calculateColors,
          noAlloc: noAlloc
        },
        pickingColors: { size: 3, type: GL.UNSIGNED_BYTE, update: this.calculatePickingColors, noAlloc: noAlloc }
      });
      /* eslint-enable max-len */
    }
  }, {
    key: 'updateAttribute',
    value: function updateAttribute(_ref) {
      var props = _ref.props,
          oldProps = _ref.oldProps,
          changeFlags = _ref.changeFlags;

      if (props.fp64 !== oldProps.fp64) {
        var attributeManager = this.getAttributeManager();
        attributeManager.invalidateAll();

        if (props.fp64 && props.coordinateSystem === COORDINATE_SYSTEM.LNGLAT) {
          attributeManager.add({
            positions64xyLow: { size: 2, update: this.calculatePositionsLow }
          });
        } else {
          attributeManager.remove(['positions64xyLow']);
        }
      }
    }
  }, {
    key: 'draw',
    value: function draw(_ref2) {
      var uniforms = _ref2.uniforms;
      var _props = this.props,
          extruded = _props.extruded,
          lightSettings = _props.lightSettings,
          elevationScale = _props.elevationScale;


      this.state.model.render(Object.assign({}, uniforms, {
        extruded: extruded ? 1.0 : 0.0,
        elevationScale: elevationScale
      }, lightSettings));
    }
  }, {
    key: 'updateState',
    value: function updateState(_ref3) {
      var props = _ref3.props,
          oldProps = _ref3.oldProps,
          changeFlags = _ref3.changeFlags;

      _get(SolidPolygonLayer.prototype.__proto__ || Object.getPrototypeOf(SolidPolygonLayer.prototype), 'updateState', this).call(this, { props: props, oldProps: oldProps, changeFlags: changeFlags });

      var regenerateModel = this.updateGeometry({ props: props, oldProps: oldProps, changeFlags: changeFlags });

      if (regenerateModel) {
        var gl = this.context.gl;

        if (this.state.model) {
          this.state.model.delete();
        }
        this.setState({ model: this._getModel(gl) });
      }
      this.updateAttribute({ props: props, oldProps: oldProps, changeFlags: changeFlags });
    }

    /* eslint-disable complexity */

  }, {
    key: 'updateGeometry',
    value: function updateGeometry(_ref4) {
      var _this2 = this;

      var props = _ref4.props,
          oldProps = _ref4.oldProps,
          changeFlags = _ref4.changeFlags;

      var geometryConfigChanged = props.extruded !== oldProps.extruded || props.wireframe !== oldProps.wireframe || props.fp64 !== oldProps.fp64 || changeFlags.updateTriggersChanged && (changeFlags.updateTriggersChanged.all || changeFlags.updateTriggersChanged.getPolygon);

      // check if updateTriggers.getElevation has been triggered
      var getElevationTriggered = changeFlags.updateTriggersChanged && compareProps({
        oldProps: oldProps.updateTriggers.getElevation || {},
        newProps: props.updateTriggers.getElevation || {},
        triggerName: 'getElevation'
      });

      // When the geometry config  or the data is changed,
      // tessellator needs to be invoked
      if (changeFlags.dataChanged || geometryConfigChanged || getElevationTriggered) {
        var getPolygon = props.getPolygon,
            extruded = props.extruded,
            wireframe = props.wireframe,
            getElevation = props.getElevation;

        // TODO - avoid creating a temporary array here: let the tesselator iterate

        var polygons = props.data.map(getPolygon);

        this.setState({
          polygonTesselator: !extruded ? new PolygonTesselator({ polygons: polygons, fp64: this.props.fp64 }) : new PolygonTesselatorExtruded({
            polygons: polygons,
            wireframe: wireframe,
            getHeight: function getHeight(polygonIndex) {
              return getElevation(_this2.props.data[polygonIndex]);
            },
            fp64: this.props.fp64
          })
        });

        this.state.attributeManager.invalidateAll();
      }

      return geometryConfigChanged;
    }
    /* eslint-disable complexity */

  }, {
    key: '_getModel',
    value: function _getModel(gl) {
      return new Model(gl, Object.assign({}, this.getShaders(), {
        id: this.props.id,
        geometry: new Geometry({
          drawMode: this.props.wireframe ? GL.LINES : GL.TRIANGLES,
          attributes: {}
        }),
        vertexCount: 0,
        isIndexed: true,
        shaderCache: this.context.shaderCache
      }));
    }
  }, {
    key: 'calculateIndices',
    value: function calculateIndices(attribute) {
      attribute.value = this.state.polygonTesselator.indices();
      attribute.target = GL.ELEMENT_ARRAY_BUFFER;
      this.state.model.setVertexCount(attribute.value.length / attribute.size);
    }
  }, {
    key: 'calculatePositions',
    value: function calculatePositions(attribute) {
      attribute.value = this.state.polygonTesselator.positions().positions;
    }
  }, {
    key: 'calculatePositionsLow',
    value: function calculatePositionsLow(attribute) {
      attribute.value = this.state.polygonTesselator.positions().positions64xyLow;
    }
  }, {
    key: 'calculateNormals',
    value: function calculateNormals(attribute) {
      attribute.value = this.state.polygonTesselator.normals();
    }
  }, {
    key: 'calculateColors',
    value: function calculateColors(attribute) {
      var _this3 = this;

      attribute.value = this.state.polygonTesselator.colors({
        getColor: function getColor(polygonIndex) {
          return _this3.props.getColor(_this3.props.data[polygonIndex]);
        }
      });
    }

    // Override the default picking colors calculation

  }, {
    key: 'calculatePickingColors',
    value: function calculatePickingColors(attribute) {
      attribute.value = this.state.polygonTesselator.pickingColors();
    }
  }]);

  return SolidPolygonLayer;
}(Layer);

export default SolidPolygonLayer;


SolidPolygonLayer.layerName = 'SolidPolygonLayer';
SolidPolygonLayer.defaultProps = defaultProps;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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